/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.styling.css.util.Signature;

public abstract class FilteredPowerSetBuilder<T, R> {
    private List<T> domain;
    private Set<Signature> rejects = new HashSet<Signature>();

    public FilteredPowerSetBuilder(List<T> domain) {
        this.domain = domain;
    }

    private boolean rejected(Signature s, int k) {
        for (Signature reject : this.rejects) {
            if (!s.contains(reject, k)) continue;
            return true;
        }
        return false;
    }

    public List<R> buildPowerSet() {
        List result = new ArrayList();
        Signature s = Signature.newSignature(this.domain.size());
        this.fill(s, 0, this.domain.size(), result);
        result = this.postFilterResult(result);
        return result;
    }

    protected List<R> postFilterResult(List<R> result) {
        return result;
    }

    void fill(Signature s, int k, int n, List<R> result) {
        List<T> objects = this.listFromSignature(s);
        if (!objects.isEmpty() && !this.accept(objects)) {
            this.rejects.add((Signature)s.clone());
            return;
        }
        if (k == n) {
            List<R> combined = this.buildResult(objects);
            if (combined != null) {
                result.addAll(combined);
            }
        } else {
            s.set(k, true);
            if (!this.rejected(s, k)) {
                this.fill(s, k + 1, n, result);
            }
            s.set(k, false);
            if (!this.rejected(s, k)) {
                this.fill(s, k + 1, n, result);
            }
        }
    }

    protected abstract List<R> buildResult(List<T> var1);

    protected abstract boolean accept(List<T> var1);

    private List<T> listFromSignature(Signature signature) {
        ArrayList<T> test = new ArrayList<T>();
        for (int i = 0; i < this.domain.size(); ++i) {
            if (!signature.get(i)) continue;
            test.add(this.domain.get(i));
        }
        return test;
    }
}

