/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import java.util.List;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.styling.css.util.TypeAggregator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.parameter.Parameter;

class FilterTypeVisitor
extends DefaultFilterVisitor {
    TypeAggregator aggregator;

    public FilterTypeVisitor(TypeAggregator aggregator) {
        this.aggregator = aggregator;
    }

    String getPropertyName(Expression ex) {
        if (ex instanceof PropertyName) {
            PropertyName pn = (PropertyName)ex;
            return pn.getPropertyName();
        }
        return null;
    }

    Object getLiteralValue(Expression ex) {
        if (ex instanceof Literal) {
            return ex.evaluate(null);
        }
        return null;
    }

    @Override
    public Object visit(Add expression, Object data) {
        this.visitMathExpression((BinaryExpression)expression);
        return super.visit(expression, data);
    }

    @Override
    public Object visit(Multiply expression, Object data) {
        this.visitMathExpression((BinaryExpression)expression);
        return super.visit(expression, data);
    }

    @Override
    public Object visit(Divide expression, Object data) {
        this.visitMathExpression((BinaryExpression)expression);
        return super.visit(expression, data);
    }

    @Override
    public Object visit(Subtract expression, Object data) {
        this.visitMathExpression((BinaryExpression)expression);
        return super.visit(expression, data);
    }

    private void visitMathExpression(BinaryExpression expression) {
        String name = this.getPropertyName(expression.getExpression1());
        if (name != null) {
            this.aggregator.addType(name, Double.class);
        }
        if ((name = this.getPropertyName(expression.getExpression2())) != null) {
            this.aggregator.addType(name, Double.class);
        }
    }

    @Override
    public Object visit(Function expression, Object data) {
        FunctionName name = expression.getFunctionName();
        if (name != null && name.getArgumentCount() > 0) {
            List argumentTypes = name.getArguments();
            List arguments = expression.getParameters();
            for (int i = 0; i < Math.min(arguments.size(), argumentTypes.size()); ++i) {
                Expression ex = (Expression)arguments.get(i);
                String propertyName = this.getPropertyName(ex);
                Parameter argumentType = (Parameter)argumentTypes.get(i);
                if (propertyName == null || argumentType == null) continue;
                this.aggregator.addType(propertyName, argumentType.getType());
            }
        }
        return super.visit(expression, data);
    }

    @Override
    public Object visit(After after, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)after);
        return super.visit(after, data);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)anyInteracts);
        return super.visit(anyInteracts, data);
    }

    @Override
    public Object visit(Before before, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)before);
        return super.visit(before, data);
    }

    @Override
    public Object visit(Begins begins, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)begins);
        return super.visit(begins, data);
    }

    @Override
    public Object visit(BegunBy begunBy, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)begunBy);
        return super.visit(begunBy, data);
    }

    @Override
    public Object visit(During during, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)during);
        return super.visit(during, data);
    }

    @Override
    public Object visit(EndedBy endedBy, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)endedBy);
        return super.visit(endedBy, data);
    }

    @Override
    public Object visit(Ends ends, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)ends);
        return super.visit(ends, data);
    }

    @Override
    public Object visit(Meets meets, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)meets);
        return super.visit(meets, data);
    }

    @Override
    public Object visit(MetBy metBy, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)metBy);
        return super.visit(metBy, data);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)overlappedBy);
        return super.visit(overlappedBy, data);
    }

    @Override
    public Object visit(TContains contains, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)contains);
        return super.visit(contains, data);
    }

    @Override
    public Object visit(TEquals equals, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)equals);
        return super.visit(equals, data);
    }

    @Override
    public Object visit(TOverlaps contains, Object data) {
        this.visitTemporalExpression((BinaryTemporalOperator)contains);
        return super.visit(contains, data);
    }

    private void visitTemporalExpression(BinaryTemporalOperator expression) {
        String name = this.getPropertyName(expression.getExpression1());
        if (name != null) {
            this.aggregator.addType(name, Date.class);
        }
        if ((name = this.getPropertyName(expression.getExpression2())) != null) {
            this.aggregator.addType(name, Date.class);
        }
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object data) {
        String name = this.getPropertyName(filter.getExpression());
        if (name != null) {
            Object v2;
            Object v1 = this.getLiteralValue(filter.getLowerBoundary());
            if (v1 != null) {
                this.aggregator.addType(name, v1.getClass());
            }
            if ((v2 = this.getLiteralValue(filter.getUpperBoundary())) != null) {
                this.aggregator.addType(name, v2.getClass());
            }
        }
        return super.visit(filter, data);
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object data) {
        this.visitBinaryComparison((BinaryComparisonOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        this.visitBinaryComparison((BinaryComparisonOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object data) {
        this.visitBinaryComparison((BinaryComparisonOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        this.visitBinaryComparison((BinaryComparisonOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object data) {
        this.visitBinaryComparison((BinaryComparisonOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        this.visitBinaryComparison((BinaryComparisonOperator)filter);
        return super.visit(filter, data);
    }

    private void visitBinaryComparison(BinaryComparisonOperator filter) {
        Object value;
        String name = this.getPropertyName(filter.getExpression1());
        if (name != null && (value = this.getLiteralValue(filter.getExpression2())) != null) {
            this.aggregator.addType(name, value.getClass());
        }
        if ((name = this.getPropertyName(filter.getExpression2())) != null && (value = this.getLiteralValue(filter.getExpression1())) != null) {
            this.aggregator.addType(name, value.getClass());
        }
    }

    @Override
    public Object visit(PropertyIsLike filter, Object data) {
        String name = this.getPropertyName(filter.getExpression());
        if (name != null) {
            this.aggregator.addType(name, String.class);
        }
        return null;
    }

    @Override
    public Object visit(Beyond filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Contains filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Crosses filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Disjoint filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(DWithin filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Equals filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Intersects filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Overlaps filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Touches filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    @Override
    public Object visit(Within filter, Object data) {
        this.visitBinarySpatialOperator((BinarySpatialOperator)filter);
        return super.visit(filter, data);
    }

    private void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        String name = this.getPropertyName(filter.getExpression1());
        if (name != null) {
            this.aggregator.addType(name, Geometry.class);
        }
        if ((name = this.getPropertyName(filter.getExpression2())) != null) {
            this.aggregator.addType(name, Geometry.class);
        }
    }
}

