/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.css.CSSParseException;
import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.Directive;
import org.geotools.styling.css.Property;
import org.geotools.styling.css.Stylesheet;
import org.geotools.styling.css.Value;
import org.geotools.styling.css.selector.Data;
import org.geotools.styling.css.selector.Id;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.ScaleRange;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.TypeName;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.parboiled.Action;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

@BuildParseTree
public class CssParser
extends BaseParser<Object> {
    static CssParser INSTANCE;
    static final Object MARKER;

    protected CssParser() {
    }

    public static CssParser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = (CssParser)Parboiled.createParser(CssParser.class, (Object[])new Object[0]);
        }
        return INSTANCE;
    }

    public static Stylesheet parse(String css) throws CSSParseException {
        CssParser parser = CssParser.getInstance();
        ReportingParseRunner runner = new ReportingParseRunner(parser.StyleSheet());
        ParsingResult result = runner.run(css);
        if (result.hasErrors()) {
            throw new CSSParseException(result.parseErrors);
        }
        Stylesheet ss = (Stylesheet)result.parseTreeRoot.getValue();
        return ss;
    }

    Rule StyleSheet() {
        return this.Sequence(this.ZeroOrMore(this.Directive(), this.OptionalWhiteSpace(), new Object[0]), this.OneOrMore(this.CssRule()), new Object[]{this.WhiteSpaceOrIgnoredComment(), EOI, this.push(new Stylesheet(this.popAll(CssRule.class), this.popAll(Directive.class)))});
    }

    Rule Directive() {
        return this.Sequence("@", this.Identifier(), new Object[]{this.push(this.match()), this.WhiteSpace(), this.String(), this.Ch(';'), this.swap(), this.push(new Directive((String)this.pop(), ((Value.Literal)this.pop()).toLiteral()))});
    }

    Rule CssRule() {
        return this.Sequence(this.WhiteSpaceOrComment(), this.Selector(), new Object[]{this.OptionalWhiteSpace(), Character.valueOf('{'), this.WhiteSpaceOrIgnoredComment(), this.PropertyList(), this.WhiteSpaceOrIgnoredComment(), Character.valueOf('}'), new Action(){

            public boolean run(Context ctx) {
                List properties = (List)CssParser.this.pop();
                Selector selector = (Selector)CssParser.this.pop();
                if (!ctx.getValueStack().isEmpty() && CssParser.this.peek() instanceof String) {
                    String comment = (String)CssParser.this.pop();
                    comment = comment.trim();
                    while (!ctx.getValueStack().isEmpty() && CssParser.this.peek() instanceof String) {
                        CssParser.this.pop();
                    }
                    CssParser.this.push(new CssRule(selector, properties, comment));
                } else {
                    CssParser.this.push(new CssRule(selector, properties));
                }
                return true;
            }
        }});
    }

    Rule Selector() {
        return this.FirstOf(this.OrSelector(), this.AndSelector(), new Object[]{this.BasicSelector()});
    }

    Rule BasicSelector() {
        return this.FirstOf(this.CatchAllSelector(), this.ECQLSelector(), new Object[]{this.MinScaleSelector(), this.MaxScaleSelector(), this.IdSelector(), this.PseudoClassSelector(), this.NumberedPseudoClassSelector(), this.TypenameSelector()});
    }

    Rule AndSelector() {
        return this.Sequence(this.BasicSelector(), this.OptionalWhiteSpace(), new Object[]{this.FirstOf(this.AndSelector(), this.BasicSelector(), new Object[0]), this.swap() && this.push(Selector.and((Selector)this.pop(), (Selector)this.pop(), null))});
    }

    Rule OrSelector() {
        return this.Sequence(this.FirstOf(this.AndSelector(), this.BasicSelector(), new Object[0]), this.OptionalWhiteSpace(), new Object[]{Character.valueOf(','), this.OptionalWhiteSpace(), this.Selector(), this.swap() && this.push(Selector.or((Selector)this.pop(), (Selector)this.pop(), null))});
    }

    @SuppressSubnodes
    Rule PseudoClassSelector() {
        return this.Sequence(Character.valueOf(':'), this.ClassName(), new Object[]{this.push(PseudoClass.newPseudoClass((String)this.pop()))});
    }

    @SuppressSubnodes
    Rule NumberedPseudoClassSelector() {
        return this.Sequence(":nth-", this.ClassName(), new Object[]{Character.valueOf('('), this.Number(), this.push(this.match()), Character.valueOf(')'), this.swap() && this.push(PseudoClass.newPseudoClass((String)this.pop(), Integer.valueOf((String)this.pop())))});
    }

    Rule ClassName() {
        return this.Sequence(this.FirstOf("mark", "stroke", new Object[]{"fill", "symbol", "shield"}), this.push(this.match()), new Object[0]);
    }

    @SuppressSubnodes
    Rule TypenameSelector() {
        return this.Sequence(this.Sequence(this.Identifier(), this.Optional(Character.valueOf(':'), this.Identifier(), new Object[0]), new Object[0]), this.push(new TypeName(this.match())), new Object[0]);
    }

    @SuppressSubnodes
    Rule IdSelector() {
        return this.Sequence(Character.valueOf('#'), this.Sequence(this.Identifier(), this.Optional(Character.valueOf(':'), this.Identifier(), new Object[0]), new Object[]{this.Optional(Character.valueOf('.'), this.Sequence(this.TestNot(this.AnyOf("\"'[]")), ANY, new Object[0]), new Object[0])}), new Object[]{this.push(new Id(this.match()))});
    }

    Rule CatchAllSelector() {
        return this.Sequence(Character.valueOf('*'), this.push(Selector.ACCEPT), new Object[0]);
    }

    Rule MaxScaleSelector() {
        return this.Sequence("[", this.OptionalWhiteSpace(), new Object[]{"@scale", this.OptionalWhiteSpace(), this.FirstOf("<=", "<", new Object[0]), this.OptionalWhiteSpace(), this.Number(), this.push(new ScaleRange(0.0, true, Double.valueOf(this.match()), false)), this.OptionalWhiteSpace(), "]"});
    }

    Rule MinScaleSelector() {
        return this.Sequence("[", this.OptionalWhiteSpace(), new Object[]{"@scale", this.OptionalWhiteSpace(), this.FirstOf(">=", ">", new Object[0]), this.OptionalWhiteSpace(), this.Number(), this.push(new ScaleRange(Double.valueOf(this.match()), true, Double.POSITIVE_INFINITY, true)), this.OptionalWhiteSpace(), "]"});
    }

    Rule PropertyList() {
        return this.Sequence(this.Property(), this.ZeroOrMore(this.Sequence(this.WhitespaceOrIgnoredComment(), Character.valueOf(';'), new Object[]{this.WhiteSpaceOrIgnoredComment(), this.Property()})), new Object[]{this.Optional(Character.valueOf(';')), this.push(this.popAll(Property.class))});
    }

    Rule WhitespaceOrIgnoredComment() {
        return this.ZeroOrMore(this.FirstOf(this.WhiteSpace(), this.IgnoredComment(), new Object[0]));
    }

    Rule Property() {
        return this.Sequence(this.Identifier(), this.push(this.match()), new Object[]{this.OptionalWhiteSpace(), this.Colon(), this.OptionalWhiteSpace(), this.Sequence(this.Value(), this.OptionalWhiteSpace(), new Object[]{this.ZeroOrMore(Character.valueOf(','), this.OptionalWhiteSpace(), new Object[]{this.Value()})}), this.push(this.popAll(Value.class)) && this.swap() && this.push(new Property(this.pop(String.class), this.pop(List.class)))});
    }

    @SuppressNode
    Rule Colon() {
        return this.Ch(':');
    }

    Rule Value() {
        return this.FirstOf(this.MultiValue(), this.SimpleValue(), new Object[0]);
    }

    Rule SimpleValue() {
        return this.FirstOf(this.URLFunction(), this.Function(), new Object[]{this.Color(), this.NamedColor(), this.Measure(), this.ValueIdentifier(), this.MixedExpression()});
    }

    Rule MixedExpression() {
        return this.Sequence(this.push(MARKER), this.OneOrMore(this.FirstOf(this.ECQLExpression(), this.String(), new Object[0])), new Object[]{new Action(){

            public boolean run(Context ctx) {
                Object value = CssParser.this.pop();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                Object firstValue = null;
                while (value != MARKER) {
                    firstValue = value;
                    if (value instanceof Value) {
                        expressions.add(((Value)value).toExpression());
                    }
                    value = CssParser.this.pop();
                }
                if (expressions.size() == 0) {
                    return false;
                }
                if (expressions.size() == 1) {
                    CssParser.this.push(firstValue);
                } else {
                    Collections.reverse(expressions);
                    Function function = Data.FF.function("Concatenate", expressions.toArray(new Expression[expressions.size()]));
                    CssParser.this.push(new Value.Expression((Expression)function));
                }
                return true;
            }
        }});
    }

    Rule MultiValue() {
        return this.Sequence(this.push(MARKER), this.SimpleValue(), new Object[]{this.OneOrMore(this.WhiteSpace(), this.SimpleValue(), new Object[0]), this.push(new Value.MultiValue(this.popAll(Value.class)))});
    }

    Rule Function() {
        return this.Sequence(this.Identifier(), this.push(this.match()), new Object[]{Character.valueOf('('), this.Value(), this.ZeroOrMore(this.OptionalWhiteSpace(), Character.valueOf(','), new Object[]{this.OptionalWhiteSpace(), this.Value()}), Character.valueOf(')'), this.push(this.buildFunction(this.popAll(Value.class), (String)this.pop()))});
    }

    Value.Function buildFunction(List<Value> values, String name) {
        return new Value.Function(name, values);
    }

    Rule URLFunction() {
        return this.Sequence("url", this.OptionalWhiteSpace(), new Object[]{"(", this.OptionalWhiteSpace(), this.URL(), this.OptionalWhiteSpace(), ")", this.push(new Value.Function("url", (Value)this.pop()))});
    }

    Rule URL() {
        return this.FirstOf(this.QuotedURL(), this.SimpleURL(), new Object[0]);
    }

    Rule SimpleURL() {
        return this.Sequence(this.OneOrMore(this.FirstOf(this.Alphanumeric(), this.AnyOf("-._]:/?#[]@|$&'*+,;="), new Object[0])), this.push(new Value.Literal(this.match())), new Object[0]);
    }

    Rule QuotedURL() {
        return this.Sequence("'", this.Sequence(this.OneOrMore(this.FirstOf(this.Alphanumeric(), this.AnyOf("-._]:/?#[]@|$&*+,;="), new Object[0])), this.push(new Value.Literal(this.match())), new Object[0]), new Object[]{"'"});
    }

    Rule ValueIdentifier() {
        return this.Sequence(this.Identifier(), this.push(new Value.Literal(this.match())), new Object[0]);
    }

    Rule String() {
        return this.FirstOf(this.Sequence(Character.valueOf('\''), this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("'\\")), ANY, new Object[0])), new Object[]{this.push(new Value.Literal(this.match())), Character.valueOf('\'')}), this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("\"\\")), ANY, new Object[0])), new Object[]{this.push(new Value.Literal(this.match())), Character.valueOf('\"')}), new Object[0]);
    }

    Rule Measure() {
        return this.Sequence(this.Sequence(this.Number(), this.Optional(this.FirstOf(this.String("px"), this.String("m"), new Object[]{this.String("ft"), this.String("%"), this.String("deg")})), new Object[0]), this.push(new Value.Literal(this.match())), new Object[0]);
    }

    Rule ECQLExpression() {
        return this.ECQL(new Action(){

            public boolean run(Context ctx) {
                String expression = CssParser.this.match();
                try {
                    Expression e = ECQL.toExpression((String)expression);
                    ctx.getValueStack().push((Object)new Value.Expression(e));
                    return true;
                }
                catch (CQLException e) {
                    return false;
                }
            }
        });
    }

    Rule ECQLSelector() {
        return this.ECQL(new Action(){

            public boolean run(Context ctx) {
                String expression = CssParser.this.match();
                try {
                    Filter f = ECQL.toFilter((String)expression);
                    ctx.getValueStack().push((Object)new Data(f));
                    return true;
                }
                catch (CQLException e) {
                    return false;
                }
            }
        });
    }

    Rule ECQL(Action parserChecker) {
        return this.Sequence(Character.valueOf('['), this.OneOrMore(this.FirstOf(this.SingleQuotedString(), this.DoubleQuotedString(), new Object[]{this.Sequence(this.TestNot(this.AnyOf("\"'[]")), ANY, new Object[0])})), new Object[]{parserChecker, Character.valueOf(']')});
    }

    Rule DoubleQuotedString() {
        return this.Sequence(Character.valueOf('\"'), this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("\r\n\"\\")), ANY, new Object[0])), new Object[]{Character.valueOf('\"')});
    }

    Rule SingleQuotedString() {
        return this.Sequence(Character.valueOf('\''), this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("\r\n'\\")), ANY, new Object[0])), new Object[]{Character.valueOf('\'')});
    }

    Rule IntegralNumber() {
        return this.OneOrMore(this.Digit());
    }

    Rule Number() {
        return this.Sequence(this.Optional(this.AnyOf("-+")), this.OneOrMore(this.Digit()), new Object[]{this.Optional(Character.valueOf('.'), this.ZeroOrMore(this.Digit()), new Object[0])});
    }

    @SuppressSubnodes
    Rule Color() {
        return this.Sequence(this.Sequence(Character.valueOf('#'), this.FirstOf(this.Sequence(this.Hex(), this.Hex(), new Object[]{this.Hex(), this.Hex(), this.Hex(), this.Hex()}), this.Sequence(this.Hex(), this.Hex(), new Object[]{this.Hex()}), new Object[0]), new Object[0]), this.push(new Value.Literal(this.toHexColor(this.match()))), new Object[0]);
    }

    String toHexColor(String hex) {
        if (hex.length() == 7) {
            return hex;
        }
        char r = hex.charAt(1);
        char g = hex.charAt(2);
        char b = hex.charAt(3);
        return "#" + r + r + g + g + b + b;
    }

    @SuppressSubnodes
    Rule NamedColor() {
        String[] colorNames = new String[Value.COLORS_TO_HEX.size()];
        int i = 0;
        for (String name : Value.COLORS_TO_HEX.keySet()) {
            colorNames[i++] = name;
        }
        Arrays.sort(colorNames, Collections.reverseOrder());
        Object[] insensitiveColorNames = new Rule[colorNames.length];
        for (int j = 0; j < colorNames.length; ++j) {
            insensitiveColorNames[j] = this.IgnoreCase(colorNames[j]);
        }
        return this.Sequence(this.FirstOf(insensitiveColorNames), new Action(){

            public boolean run(Context ctx) {
                String hex = Value.COLORS_TO_HEX.get(CssParser.this.match().toLowerCase());
                CssParser.this.push(new Value.Literal(hex));
                return true;
            }
        }, new Object[0]);
    }

    @SuppressNode
    Rule Identifier() {
        return this.Sequence(this.Optional(Character.valueOf('-')), this.NameStart(), new Object[]{this.ZeroOrMore(this.NameCharacter())});
    }

    @SuppressNode
    Rule NameStart() {
        return this.FirstOf(Character.valueOf('_'), this.Alpha(), new Object[0]);
    }

    @SuppressNode
    Rule NameCharacter() {
        return this.FirstOf(this.AnyOf("-_"), this.Alphanumeric(), new Object[0]);
    }

    @SuppressNode
    Rule Hex() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.Digit()});
    }

    @SuppressNode
    Rule Digit() {
        return this.CharRange('0', '9');
    }

    @SuppressNode
    Rule Alphanumeric() {
        return this.FirstOf(this.Alpha(), this.Digit(), new Object[0]);
    }

    @SuppressNode
    Rule Alpha() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[0]);
    }

    Rule IgnoredComment() {
        return this.Sequence("/*", this.ZeroOrMore(this.TestNot("*/"), ANY, new Object[0]), new Object[]{"*/"});
    }

    Rule RuleComment() {
        return this.Sequence("/*", this.ZeroOrMore(this.TestNot("*/"), ANY, new Object[0]), new Object[]{this.push(this.match()), "*/"});
    }

    @SuppressNode
    Rule WhiteSpaceOrIgnoredComment() {
        return this.ZeroOrMore(this.FirstOf(this.IgnoredComment(), this.WhiteSpace(), new Object[0]));
    }

    @SuppressNode
    Rule WhiteSpaceOrComment() {
        return this.ZeroOrMore(this.FirstOf(this.RuleComment(), this.WhiteSpace(), new Object[0]));
    }

    @SuppressNode
    Rule OptionalWhiteSpace() {
        return this.ZeroOrMore(this.AnyOf(" \r\t\f\n"));
    }

    @SuppressNode
    Rule WhiteSpace() {
        return this.OneOrMore(this.AnyOf(" \r\t\f\n"));
    }

    protected Rule fromStringLiteral(String string) {
        return string.matches("\\s+$") ? this.Sequence(this.String(string.substring(0, string.length() - 1)), this.OptionalWhiteSpace(), new Object[0]) : this.String(string);
    }

    <T> T pop(Class<T> clazz) {
        return (T)this.pop();
    }

    <T> List<T> popAll(Class<T> clazz) {
        ValueStack valueStack = this.getContext().getValueStack();
        ArrayList<Object> result = new ArrayList<Object>();
        while (!valueStack.isEmpty() && clazz.isInstance(valueStack.peek())) {
            result.add(valueStack.pop());
        }
        if (!valueStack.isEmpty() && valueStack.peek() == MARKER) {
            valueStack.pop();
        }
        Collections.reverse(result);
        return result;
    }

    static {
        MARKER = new Object();
    }
}

