/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.util.Map;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;

public class FactoryUsingOracleSQL
extends FactoryUsingAnsiSQL {
    private final Pattern pattern = Pattern.compile("\\sAS\\s");

    public FactoryUsingOracleSQL(Hints userHints, Connection connection) {
        super(userHints, connection);
    }

    public FactoryUsingOracleSQL(Hints userHints, Connection connection, String epsgSchema) {
        super(userHints, connection);
        this.adaptTableNames(epsgSchema);
    }

    @Override
    protected String adaptSQL(String statement) {
        return this.pattern.matcher(super.adaptSQL(statement)).replaceAll(" ");
    }

    private void adaptTableNames(String epsgSchema) {
        if (epsgSchema != null && (epsgSchema = epsgSchema.trim()).length() != 0) {
            for (Map.Entry entry : this.map.entrySet()) {
                String tableName = (String)entry.getValue();
                if (!tableName.startsWith("epsg_")) continue;
                entry.setValue(epsgSchema + '.' + tableName);
            }
        }
    }
}

