/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.mosaic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.Tile;
import org.geotools.geopkg.TileEntry;
import org.geotools.geopkg.TileMatrix;
import org.geotools.geopkg.TileReader;
import org.geotools.geopkg.mosaic.GeoPackageFormat;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoPackageReader
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.geopkg.mosaic");
    protected static final int DEFAULT_TILE_SIZE = 256;
    protected static final int ZOOM_LEVEL_BASE = 2;
    protected GridCoverageFactory coverageFactory;
    protected File sourceFile;
    protected Map<String, TileEntry> tiles = new HashMap<String, TileEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoPackageReader(Object source, Hints hints) throws IOException {
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(this.hints);
        this.sourceFile = GeoPackageFormat.getFileFromSource(source);
        try (GeoPackage file = new GeoPackage(this.sourceFile);){
            for (TileEntry tile : file.tiles()) {
                this.tiles.put(tile.getTableName(), tile);
            }
        }
    }

    public Format getFormat() {
        return new GeoPackageFormat();
    }

    @Override
    protected boolean checkName(String coverageName) {
        Utilities.ensureNonNull((String)"coverageName", (Object)coverageName);
        return this.tiles.keySet().contains(coverageName);
    }

    @Override
    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return new GeneralEnvelope((Envelope)this.tiles.get(coverageName).getBounds());
    }

    @Override
    protected double[] getHighestRes(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        List<TileMatrix> matrices = this.tiles.get(coverageName).getTileMatricies();
        TileMatrix matrix = matrices.get(matrices.size() - 1);
        return new double[]{matrix.getXPixelSize(), matrix.getYPixelSize()};
    }

    @Override
    public GridEnvelope getOriginalGridRange(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        List<TileMatrix> matrices = this.tiles.get(coverageName).getTileMatricies();
        TileMatrix matrix = matrices.get(matrices.size() - 1);
        return new GridEnvelope2D(new Rectangle(matrix.getMatrixWidth() * matrix.getTileWidth(), matrix.getMatrixHeight() * matrix.getTileHeight()));
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        try {
            return CRS.decode((String)("EPSG:" + this.tiles.get(coverageName).getSrid()), (boolean)true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String[] getGridCoverageNames() {
        return this.tiles.keySet().toArray(new String[this.tiles.size()]);
    }

    @Override
    public int getGridCoverageCount() {
        return this.tiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        TileEntry entry = this.tiles.get(coverageName);
        BufferedImage image = null;
        ReferencedEnvelope resultEnvelope = null;
        try (GeoPackage file = new GeoPackage(this.sourceFile);){
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(coverageName);
            ReferencedEnvelope requestedEnvelope = null;
            Rectangle dim = null;
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    ParameterValue param = (ParameterValue)parameters[i];
                    ReferenceIdentifier name = param.getDescriptor().getName();
                    if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    try {
                        requestedEnvelope = ReferencedEnvelope.create(gg.getEnvelope(), gg.getCoordinateReferenceSystem()).transform(crs, true);
                    }
                    catch (Exception e) {
                        requestedEnvelope = null;
                    }
                    dim = gg.getGridRange2D().getBounds();
                }
            }
            TileMatrix bestMatrix = null;
            if (requestedEnvelope != null && dim != null) {
                double horRes = requestedEnvelope.getSpan(0) / dim.getWidth();
                double worldSpan = crs.getCoordinateSystem().getAxis(0).getMaximumValue() - crs.getCoordinateSystem().getAxis(0).getMinimumValue();
                double difference = Double.MAX_VALUE;
                for (TileMatrix matrix : entry.getTileMatricies()) {
                    double newRes = worldSpan / (double)(matrix.getMatrixWidth() * matrix.getTileWidth());
                    double newDifference = Math.abs(horRes - newRes);
                    if (!(newDifference < difference)) continue;
                    difference = newDifference;
                    bestMatrix = matrix;
                }
            }
            if (bestMatrix == null) {
                bestMatrix = entry.getTileMatricies().get(0);
            }
            int leftTile = file.getTileBound(entry, bestMatrix.getZoomLevel(), false, false);
            int rightTile = file.getTileBound(entry, bestMatrix.getZoomLevel(), true, false);
            int bottomTile = file.getTileBound(entry, bestMatrix.getZoomLevel(), false, true);
            int topTile = file.getTileBound(entry, bestMatrix.getZoomLevel(), true, true);
            double resX = (crs.getCoordinateSystem().getAxis(0).getMaximumValue() - crs.getCoordinateSystem().getAxis(0).getMinimumValue()) / (double)bestMatrix.getMatrixWidth().intValue();
            double resY = (crs.getCoordinateSystem().getAxis(1).getMaximumValue() - crs.getCoordinateSystem().getAxis(1).getMinimumValue()) / (double)bestMatrix.getMatrixHeight().intValue();
            double offsetX = crs.getCoordinateSystem().getAxis(0).getMinimumValue();
            double offsetY = crs.getCoordinateSystem().getAxis(1).getMinimumValue();
            if (requestedEnvelope != null) {
                leftTile = Math.max(leftTile, (int)Math.round(Math.floor((requestedEnvelope.getMinimum(0) - offsetX) / resX)));
                bottomTile = Math.max(bottomTile, (int)Math.round(Math.floor((requestedEnvelope.getMinimum(1) - offsetY) / resY)));
                rightTile = Math.max(leftTile, (int)Math.min((long)rightTile, Math.round(Math.floor((requestedEnvelope.getMaximum(0) - offsetX) / resX))));
                topTile = Math.max(bottomTile, (int)Math.min((long)topTile, Math.round(Math.floor((requestedEnvelope.getMaximum(1) - offsetY) / resY))));
            }
            int width = (rightTile - leftTile + 1) * 256;
            int height = (topTile - bottomTile + 1) * 256;
            resultEnvelope = new ReferencedEnvelope(offsetX + (double)leftTile * resX, offsetX + (double)(rightTile + 1) * resX, offsetY + (double)bottomTile * resY, offsetY + (double)(topTile + 1) * resY, crs);
            TileReader it = file.reader(entry, bestMatrix.getZoomLevel(), bestMatrix.getZoomLevel(), leftTile, rightTile, bottomTile, topTile);
            while (it.hasNext()) {
                Tile tile = it.next();
                BufferedImage tileImage = GeoPackageReader.readImage(tile.getData());
                if (image == null) {
                    image = this.getStartImage(tileImage, width, height);
                }
                int posx = (tile.getColumn() - leftTile) * 256;
                int posy = (topTile - tile.getRow()) * 256;
                image.getRaster().setRect(posx, posy, tileImage.getData());
            }
            it.close();
            if (image == null) {
                image = this.getStartImage(width, height);
            }
        }
        return this.coverageFactory.create((CharSequence)entry.getTableName(), image, (Envelope)resultEnvelope);
    }

    protected static BufferedImage readImage(byte[] data) throws IOException {
        ByteArrayInputStream bis;
        ByteArrayInputStream source = bis = new ByteArrayInputStream(data);
        ImageInputStream iis = ImageIO.createImageInputStream(source);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        ImageReader reader = readers.next();
        reader.setInput(iis, true);
        ImageReadParam param = reader.getDefaultReadParam();
        return reader.read(0, param);
    }

    protected BufferedImage getStartImage(BufferedImage copyFrom, int width, int height) {
        HashMap<String, Object> properties = null;
        if (copyFrom.getPropertyNames() != null) {
            properties = new HashMap<String, Object>();
            for (String name : copyFrom.getPropertyNames()) {
                properties.put(name, copyFrom.getProperty(name));
            }
        }
        SampleModel sm = copyFrom.getSampleModel().createCompatibleSampleModel(width, height);
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        BufferedImage image = new BufferedImage(copyFrom.getColorModel(), raster, copyFrom.isAlphaPremultiplied(), (Hashtable)((Object)properties));
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    protected BufferedImage getStartImage(int imageType, int width, int height) {
        if (imageType == 0) {
            imageType = 5;
        }
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    protected BufferedImage getStartImage(int width, int height) {
        return this.getStartImage(0, width, height);
    }

    @Override
    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        throw new IllegalArgumentException("No layer specified!");
    }
}

