/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.geom;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.IOException;
import java.io.InputStream;
import org.geotools.geopkg.geom.EnvelopeType;
import org.geotools.geopkg.geom.GeometryHeader;
import org.geotools.geopkg.geom.GeometryHeaderFlags;

public class GeoPkgGeomReader {
    protected InStream input;
    protected GeometryHeader header = null;
    protected Geometry geometry = null;

    public GeoPkgGeomReader(InStream input) {
        this.input = input;
    }

    public GeoPkgGeomReader(InputStream input) throws IOException {
        this.input = new InputStreamInStream(input);
    }

    public GeoPkgGeomReader(byte[] bytes) {
        this.input = new ByteArrayInStream(bytes);
    }

    public GeometryHeader getHeader() throws IOException {
        if (this.header == null) {
            this.header = this.readHeader();
        }
        return this.header;
    }

    public Geometry get() throws IOException {
        if (this.header == null) {
            this.header = this.readHeader();
        }
        if (this.geometry == null) {
            this.geometry = this.read();
        }
        return this.geometry;
    }

    public Envelope getEnvelope() throws IOException {
        if (this.getHeader().getFlags().getEnvelopeIndicator() == EnvelopeType.NONE) {
            return this.get().getEnvelopeInternal();
        }
        return this.getHeader().getEnvelope();
    }

    protected Geometry read() throws IOException {
        try {
            Geometry g = new WKBReader().read(this.input);
            g.setSRID(this.header.getSrid());
            return g;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    protected GeometryHeader readHeader() throws IOException {
        GeometryHeader h = new GeometryHeader();
        byte[] buf = new byte[4];
        this.input.read(buf);
        h.setFlags(new GeometryHeaderFlags(buf[3]));
        ByteOrderDataInStream din = new ByteOrderDataInStream(this.input);
        din.setOrder(h.getFlags().getEndianess());
        h.setSrid(din.readInt());
        if (h.getFlags().getEnvelopeIndicator() != EnvelopeType.NONE) {
            double x1 = din.readDouble();
            double x2 = din.readDouble();
            double y1 = din.readDouble();
            double y2 = din.readDouble();
            if (h.getFlags().getEnvelopeIndicator().getValue() > 1) {
                din.readDouble();
                din.readDouble();
            }
            if (h.getFlags().getEnvelopeIndicator().getValue() > 3) {
                din.readDouble();
                din.readDouble();
            }
            h.setEnvelope(new Envelope(x1, x2, y1, y2));
        }
        return h;
    }
}

