/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.geom.GeoPkgGeomReader;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoPkgDialect
extends PreparedStatementSQLDialect {
    protected GeoPkgGeomWriter.Configuration geomWriterConfig;

    public GeoPkgDialect(JDBCDataStore dataStore, GeoPkgGeomWriter.Configuration writerConfig) {
        super(dataStore);
        this.geomWriterConfig = writerConfig;
    }

    public GeoPkgDialect(JDBCDataStore dataStore) {
        super(dataStore);
        this.geomWriterConfig = new GeoPkgGeomWriter.Configuration();
    }

    public void initializeConnection(Connection cx) throws SQLException {
        new GeoPackage(this.dataStore.getDataSource()).init(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            boolean bl;
            ResultSet rs = st.executeQuery(String.format("SELECT * FROM gpkg_contents WHERE table_name = '%s' AND data_type = '%s'", tableName, Entry.DataType.Feature.value()));
            try {
                bl = rs.next();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return bl;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        super.encodePrimaryKey(column, sql);
        sql.append(" AUTOINCREMENT");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.encodeColumnName(null, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry g = this.geometry(rs.getBytes(column));
        return g != null ? g.getEnvelopeInternal() : null;
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.geometry(rs.getBytes(column));
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null) {
            ps.setNull(1, 2004);
        } else {
            g.setSRID(srid);
            try {
                ps.setBytes(column, new GeoPkgGeomWriter(dimension, this.geomWriterConfig).write(g));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    Geometry geometry(byte[] b) throws IOException {
        return b != null ? new GeoPkgGeomReader(b).get() : null;
    }

    public String getGeometryTypeName(Integer type) {
        return Geometries.getForSQLType(type).getName();
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("DOUBLE", Double.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        for (Geometries g : Geometries.values()) {
            mappings.put(g.getBinding(), g.getSQLType());
        }
        mappings.put(Long.class, 4);
        mappings.put(Double.class, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMapping(ResultSet columns, Connection cx) throws SQLException {
        String tbl = columns.getString("TABLE_NAME");
        String col = columns.getString("COLUMN_NAME");
        String sql = String.format("SELECT b.geometry_type_name FROM %s a, %s b WHERE a.table_name = b.table_name AND b.table_name = ? AND b.column_name = ?", "gpkg_contents", "gpkg_geometry_columns");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("%s; 1=%s, 2=%s", sql, tbl, col));
        }
        PreparedStatement ps = cx.prepareStatement(sql);
        try {
            String t;
            Geometries g;
            ps.setString(1, tbl);
            ps.setString(2, col);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && (g = Geometries.getForName(t = rs.getString(1))) != null) {
                Class<? extends Geometry> clazz = g.getBinding();
                return clazz;
            }
            rs.close();
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
        return null;
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        CoordinateReferenceSystem crs;
        GeometryDescriptor gd;
        FeatureEntry fe = (FeatureEntry)featureType.getUserData().get(FeatureEntry.class);
        if (fe == null) {
            fe = new FeatureEntry();
            fe.setIdentifier(featureType.getTypeName());
            fe.setDescription(featureType.getTypeName());
            fe.setTableName(featureType.getTypeName());
            fe.setLastChange(new Date());
        }
        if ((gd = featureType.getGeometryDescriptor()) != null) {
            fe.setGeometryColumn(gd.getLocalName());
            fe.setGeometryType(Geometries.getForBinding(gd.getType().getBinding()));
        }
        if ((crs = featureType.getCoordinateReferenceSystem()) != null) {
            Integer epsgCode = null;
            try {
                epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, "Error looking up epsg code for " + crs, e);
            }
            if (epsgCode != null) {
                fe.setSrid(epsgCode);
            }
        }
        GeoPackage geopkg = this.geopkg();
        try {
            geopkg.addGeoPackageContentsEntry(fe);
            geopkg.addGeometryColumnsEntry(fe);
            for (PropertyDescriptor descr : featureType.getDescriptors()) {
                GeometryDescriptor gd1;
                if (!(descr instanceof GeometryDescriptor) || (gd1 = (GeometryDescriptor)descr).getLocalName() == fe.getGeometryColumn()) continue;
                FeatureEntry fe1 = new FeatureEntry();
                fe1.init(fe);
                fe1.setGeometryColumn(gd1.getLocalName());
                fe1.setGeometryType(Geometries.getForBinding(gd1.getType().getBinding()));
                geopkg.addGeometryColumnsEntry(fe1);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        super.postDropTable(schemaName, featureType, cx);
        FeatureEntry fe = (FeatureEntry)featureType.getUserData().get(FeatureEntry.class);
        if (fe == null) {
            fe = new FeatureEntry();
            fe.setIdentifier(featureType.getTypeName());
            fe.setDescription(featureType.getTypeName());
            fe.setTableName(featureType.getTypeName());
        }
        GeoPackage geopkg = this.geopkg();
        try {
            geopkg.deleteGeoPackageContentsEntry(fe);
            geopkg.deleteGeometryColumnsEntry(fe);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        try {
            FeatureEntry fe = this.geopkg().feature(tableName);
            return fe != null ? fe.getSrid() : null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        try {
            FeatureEntry fe = this.geopkg().feature(tableName);
            if (fe != null) {
                return 2 + (fe.isZ() ? 1 : 0) + (fe.isM() ? 1 : 0);
            }
            return super.getGeometryDimension(schemaName, tableName, columnName, cx);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        try {
            return CRS.decode((String)("EPSG:" + srid));
        }
        catch (Exception e) {
            block8: {
                LOGGER.log(Level.FINE, "Unable to create CRS from epsg code " + srid, e);
                String sql = String.format("SELECT definition FROM %s WHERE auth_srid = %d", "gpkg_spatial_ref_sys", srid);
                LOGGER.fine(sql);
                Statement st = cx.createStatement();
                ResultSet rs = st.executeQuery(sql);
                try {
                    if (!rs.next()) break block8;
                    String wkt = rs.getString(1);
                    try {
                        CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT((String)wkt);
                        return coordinateReferenceSystem;
                    }
                    catch (Exception e2) {
                        LOGGER.log(Level.FINE, "Unable to create CRS from wkt: " + wkt, e2);
                    }
                }
                finally {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe(st);
                }
            }
            return super.createCRS(srid, cx);
        }
    }

    GeoPackage geopkg() {
        return new GeoPackage(this.dataStore);
    }
}

