/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.geopkg.GeoPkgDialect;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.sqlite.SQLiteConfig;

public class GeoPkgDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"geopkg");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);
    File baseDirectory = null;
    GeoPkgGeomWriter.Configuration writerConfig;

    public GeoPkgDataStoreFactory() {
        this.writerConfig = new GeoPkgGeomWriter.Configuration();
    }

    public GeoPkgDataStoreFactory(GeoPkgGeomWriter.Configuration writerConfig) {
        this.writerConfig = writerConfig;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected String getDatabaseID() {
        return "geopkg";
    }

    public String getDescription() {
        return "GeoPackage";
    }

    protected String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new GeoPkgDialect(dataStore, this.writerConfig);
    }

    protected String getValidationQuery() {
        return "SELECT 1";
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String db = (String)DATABASE.lookUp(params);
        if (this.baseDirectory != null && !new File(db).isAbsolute()) {
            db = new File(this.baseDirectory, db).getAbsolutePath();
        }
        return "jdbc:sqlite:" + db;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(GeoPkgDataStoreFactory.HOST.key);
        parameters.remove(GeoPkgDataStoreFactory.PORT.key);
        parameters.remove(GeoPkgDataStoreFactory.SCHEMA.key);
        parameters.remove(JDBCDataStoreFactory.USER.key);
        parameters.put(GeoPkgDataStoreFactory.USER.key, USER);
        parameters.put(GeoPkgDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    public BasicDataSource createDataSource(Map params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        GeoPkgDataStoreFactory.addConnectionProperties(dataSource);
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        return dataSource;
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        dataStore.setDatabaseSchema(null);
        return dataStore;
    }

    static void addConnectionProperties(BasicDataSource dataSource) {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        for (Map.Entry<Object, Object> e : config.toProperties().entrySet()) {
            dataSource.addConnectionProperty((String)e.getKey(), (String)e.getValue());
        }
    }
}

