/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geopkg.Entry;
import org.geotools.geopkg.FeatureEntry;
import org.geotools.geopkg.Features;
import org.geotools.geopkg.GeoPkgDataStoreFactory;
import org.geotools.geopkg.RasterEntry;
import org.geotools.geopkg.Tile;
import org.geotools.geopkg.TileEntry;
import org.geotools.geopkg.TileMatrix;
import org.geotools.geopkg.TileReader;
import org.geotools.geopkg.geom.GeoPkgGeomReader;
import org.geotools.geopkg.geom.GeoPkgGeomWriter;
import org.geotools.geopkg.geom.GeometryFunction;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.referencing.CRS;
import org.geotools.sql.SqlUtil;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.Identifier;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.sqlite.Function;

public class GeoPackage {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.geopkg");
    public static final String GEOPACKAGE_CONTENTS = "gpkg_contents";
    public static final String GEOMETRY_COLUMNS = "gpkg_geometry_columns";
    public static final String SPATIAL_REF_SYS = "gpkg_spatial_ref_sys";
    public static final String RASTER_COLUMNS = "gpkg_data_columns";
    public static final String TILE_MATRIX_METADATA = "gpkg_tile_matrix";
    public static final String METADATA = "gpkg_metadata";
    public static final String METADATA_REFERENCE = "gpkg_metadata_reference";
    public static final String TILE_MATRIX_SET = "gpkg_tile_matrix_set";
    public static final String DATA_COLUMN_CONSTRAINTS = "gpkg_data_column_constraints";
    public static final String EXTENSIONS = "gpkg_extensions";
    public static final String SPATIAL_INDEX = "gpkg_spatial_index";
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-mm-dd'T'HH:MM:ss.SSS'Z'");
    File file;
    final DataSource connPool;
    volatile JDBCDataStore dataStore;
    protected GeoPkgGeomWriter.Configuration writerConfig = new GeoPkgGeomWriter.Configuration();

    public GeoPkgGeomWriter.Configuration getWriterConfiguration() {
        return this.writerConfig;
    }

    public GeoPackage() throws IOException {
        this(File.createTempFile("geopkg", "db"));
    }

    public GeoPackage(File file) throws IOException {
        this(file, null, null);
    }

    public GeoPackage(File file, String user, String passwd) throws IOException {
        this.file = file;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (user != null) {
            params.put(GeoPkgDataStoreFactory.USER.key, user);
        }
        if (passwd != null) {
            params.put(GeoPkgDataStoreFactory.PASSWD.key, passwd);
        }
        params.put(GeoPkgDataStoreFactory.DATABASE.key, file.getPath());
        params.put(GeoPkgDataStoreFactory.DBTYPE.key, GeoPkgDataStoreFactory.DBTYPE.sample);
        this.connPool = new GeoPkgDataStoreFactory(this.writerConfig).createDataSource(params);
    }

    GeoPackage(DataSource dataSource) {
        this.connPool = dataSource;
    }

    GeoPackage(JDBCDataStore dataStore) {
        this.dataStore = dataStore;
        this.connPool = dataStore.getDataSource();
    }

    public File getFile() {
        return this.file;
    }

    public DataSource getDataSource() {
        return this.connPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                this.init(cx);
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void init(Connection cx) throws SQLException {
        this.createFunctions(cx);
        GeoPackage.runSQL("PRAGMA application_id = 0x47503130;", cx);
        this.runScript("gpkg_spatial_ref_sys.sql", cx);
        this.runScript("gpkg_geometry_columns.sql", cx);
        this.runScript("gpkg_contents.sql", cx);
        this.runScript("gpkg_tile_matrix_set.sql", cx);
        this.runScript("gpkg_tile_matrix.sql", cx);
        this.runScript("gpkg_data_columns.sql", cx);
        this.runScript("gpkg_metadata.sql", cx);
        this.runScript("gpkg_metadata_reference.sql", cx);
        this.runScript("gpkg_data_column_constraints.sql", cx);
        this.runScript("gpkg_extensions.sql", cx);
        this.addDefaultSpatialReferences();
    }

    void createFunctions(Connection cx) throws SQLException {
        while (cx instanceof DelegatingConnection) {
            cx = ((DelegatingConnection)cx).getDelegate();
        }
        Function.create((Connection)cx, (String)"ST_MinX", (Function)new GeometryFunction(){

            @Override
            public Object execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getEnvelope().getMinX();
            }
        });
        Function.create((Connection)cx, (String)"ST_MaxX", (Function)new GeometryFunction(){

            @Override
            public Object execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getEnvelope().getMaxX();
            }
        });
        Function.create((Connection)cx, (String)"ST_MinY", (Function)new GeometryFunction(){

            @Override
            public Object execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getEnvelope().getMinY();
            }
        });
        Function.create((Connection)cx, (String)"ST_MaxY", (Function)new GeometryFunction(){

            @Override
            public Object execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getEnvelope().getMaxY();
            }
        });
        Function.create((Connection)cx, (String)"ST_IsEmpty", (Function)new GeometryFunction(){

            @Override
            public Object execute(GeoPkgGeomReader reader) throws IOException {
                return reader.getHeader().getFlags().isEmpty();
            }
        });
    }

    public void close() {
        if (this.dataStore != null) {
            this.dataStore.dispose();
        }
        try {
            if (this.connPool instanceof BasicDataSource) {
                ((BasicDataSource)this.connPool).close();
            } else if (this.connPool instanceof ManageableDataSource) {
                ((ManageableDataSource)this.connPool).close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing database connection", e);
        }
    }

    public void addCRS(int srid) throws IOException {
        try {
            this.addCRS(CRS.decode((String)("EPSG:" + srid)), "epsg", srid);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void addDefaultSpatialReferences() throws SQLException {
        try {
            this.addCRS(-1, "Undefined cartesian SRS", "NONE", -1, "undefined", "undefined cartesian coordinate reference system");
            this.addCRS(0, "Undefined geographic SRS", "NONE", 0, "undefined", "undefined geographic coordinate reference system");
            this.addCRS(4326, "WGS 84 geodetic", "EPSG", 4326, "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]", "longitude/latitude coordinates in decimal degrees on the WGS 84 spheroid");
        }
        catch (IOException ex) {
            throw new SQLException("Unable to add default spatial references.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCRS(int srid, String srsName, String organization, int organizationCoordSysId, String definition, String description) throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = cx.prepareStatement(String.format("SELECT srs_id FROM %s WHERE srs_id = ?", SPATIAL_REF_SYS));
                try {
                    ResultSet rs = SqlUtil.prepare((PreparedStatement)ps).set(Integer.valueOf(srid)).log(Level.FINE).statement().executeQuery();
                    try {
                        if (rs.next()) {
                            return;
                        }
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(ps);
                }
                ps = cx.prepareStatement(String.format("INSERT INTO %s (srs_id, srs_name, organization, organization_coordsys_id, definition, description) VALUES (?,?,?,?,?,?)", SPATIAL_REF_SYS));
                try {
                    SqlUtil.prepare((PreparedStatement)ps).set(Integer.valueOf(srid)).set(srsName).set(organization).set(Integer.valueOf(organizationCoordSysId)).set(definition).set(description).log(Level.FINE).statement().execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void addCRS(CoordinateReferenceSystem crs, String auth, int srid) throws IOException {
        this.addCRS(srid, auth + ":" + srid, auth, srid, crs.toWKT(), auth + ":" + srid);
    }

    /*
     * Exception decompiling
     */
    private CoordinateReferenceSystem getCRS(int srid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> contents() {
        ArrayList<Entry> contents = new ArrayList<Entry>();
        try {
            Connection cx = this.connPool.getConnection();
            try {
                Statement st = cx.createStatement();
                try {
                    ResultSet rs = st.executeQuery("SELECT * FROM gpkg_contents");
                    try {
                        while (rs.next()) {
                        }
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(st);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureEntry> features() throws IOException {
        ArrayList<FeatureEntry> arrayList;
        Connection cx = this.connPool.getConnection();
        try {
            ArrayList<FeatureEntry> entries = new ArrayList<FeatureEntry>();
            String sql = String.format("SELECT a.*, b.column_name, b.geometry_type_name, b.z, b.m, c.organization_coordsys_id, c.definition FROM %s a, %s b, %s c WHERE a.table_name = b.table_name AND a.srs_id = c.srs_id AND a.data_type = ?", GEOPACKAGE_CONTENTS, GEOMETRY_COLUMNS, SPATIAL_REF_SYS);
            PreparedStatement ps = cx.prepareStatement(sql);
            try {
                ps.setString(1, DataType.Feature.value());
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        entries.add(this.createFeatureEntry(rs));
                    }
                }
                finally {
                    GeoPackage.close(rs);
                }
            }
            finally {
                GeoPackage.close(ps);
            }
            arrayList = entries;
        }
        catch (Throwable throwable) {
            try {
                GeoPackage.close(cx);
                throw throwable;
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        GeoPackage.close(cx);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureEntry feature(String name) throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                String sql = String.format("SELECT a.*, b.column_name, b.geometry_type_name, b.m, b.z, c.organization_coordsys_id, c.definition FROM %s a, %s b, %s c WHERE a.table_name = b.table_name  AND a.srs_id = c.srs_id  AND a.table_name = ? AND a.data_type = ?", GEOPACKAGE_CONTENTS, GEOMETRY_COLUMNS, SPATIAL_REF_SYS);
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setString(1, name);
                    ps.setString(2, DataType.Feature.value());
                    ResultSet rs = ps.executeQuery();
                    try {
                        if (!rs.next()) return null;
                        FeatureEntry featureEntry = this.createFeatureEntry(rs);
                        return featureEntry;
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void create(FeatureEntry entry, SimpleFeatureType schema) throws IOException {
        FeatureEntry e = new FeatureEntry();
        e.init(entry);
        e.setTableName(schema.getTypeName());
        if (e.getGeometryColumn() != null) {
            if (schema.getDescriptor(e.getGeometryColumn()) == null) {
                throw new IllegalArgumentException(String.format("Geometry column %s does not exist in schema", e.getGeometryColumn()));
            }
        } else {
            e.setGeometryColumn(GeoPackage.findGeometryColumn(schema));
        }
        if (e.getIdentifier() == null) {
            e.setIdentifier(schema.getTypeName());
        }
        if (e.getDescription() == null) {
            e.setDescription(e.getIdentifier());
        }
        if (e.getBounds() == null) {
            throw new IllegalArgumentException("Entry must have bounds");
        }
        if (e.getSrid() == null) {
            try {
                e.setSrid(GeoPackage.findSRID(schema));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (e.getSrid() == null) {
            throw new IllegalArgumentException("Entry must have srid");
        }
        if (e.getGeometryType() == null) {
            e.setGeometryType(GeoPackage.findGeometryType(schema));
        }
        e.setLastChange(new Date());
        schema.getUserData().put(FeatureEntry.class, e);
        JDBCDataStore dataStore = this.dataStore();
        dataStore.createSchema(schema);
        entry.init(e);
    }

    public void add(FeatureEntry entry, SimpleFeatureCollection collection) throws IOException {
        FeatureEntry e = new FeatureEntry();
        e.init(entry);
        if (e.getBounds() == null) {
            e.setBounds(collection.getBounds());
        }
        this.create(e, (SimpleFeatureType)collection.getSchema());
        DefaultTransaction tx = new DefaultTransaction();
        SimpleFeatureWriter w = this.writer(e, true, null, (Transaction)tx);
        SimpleFeatureIterator it = collection.features();
        try {
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                SimpleFeature g = (SimpleFeature)w.next();
                for (PropertyDescriptor pd : ((SimpleFeatureType)collection.getSchema()).getDescriptors()) {
                    String name = pd.getName().getLocalPart();
                    g.setAttribute(name, f.getAttribute(name));
                }
                w.write();
            }
            tx.commit();
        }
        catch (Exception ex) {
            tx.rollback();
            throw new IOException(ex);
        }
        finally {
            w.close();
            it.close();
            tx.close();
        }
        entry.init(e);
    }

    public void add(FeatureEntry entry, SimpleFeatureSource source, Filter filter) throws IOException {
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        this.add(entry, source.getFeatures(filter));
    }

    public SimpleFeatureWriter writer(FeatureEntry entry, boolean append, Filter filter, Transaction tx) throws IOException {
        JDBCDataStore dataStore = this.dataStore();
        FeatureWriter<SimpleFeatureType, SimpleFeature> w = append ? dataStore.getFeatureWriterAppend(entry.getTableName(), tx) : dataStore.getFeatureWriter(entry.getTableName(), filter, tx);
        return Features.simple(w);
    }

    public SimpleFeatureReader reader(FeatureEntry entry, Filter filter, Transaction tx) throws IOException {
        Query q = new Query(entry.getTableName());
        q.setFilter((Filter)(filter != null ? filter : Filter.INCLUDE));
        return Features.simple(this.dataStore().getFeatureReader(q, tx));
    }

    static Integer findSRID(SimpleFeatureType schema) throws Exception {
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        if (crs == null) {
            GeometryDescriptor gd = GeoPackage.findGeometryDescriptor(schema);
            crs = gd.getCoordinateReferenceSystem();
        }
        return crs != null ? CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true) : null;
    }

    static String findGeometryColumn(SimpleFeatureType schema) {
        GeometryDescriptor gd = GeoPackage.findGeometryDescriptor(schema);
        return gd != null ? gd.getLocalName() : null;
    }

    static Geometries findGeometryType(SimpleFeatureType schema) {
        GeometryDescriptor gd = GeoPackage.findGeometryDescriptor(schema);
        return gd != null ? Geometries.getForBinding(gd.getType().getBinding()) : null;
    }

    static GeometryDescriptor findGeometryDescriptor(SimpleFeatureType schema) {
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        if (gd == null) {
            for (PropertyDescriptor pd : schema.getDescriptors()) {
                if (!(pd instanceof GeometryDescriptor)) continue;
                return (GeometryDescriptor)pd;
            }
        }
        return gd;
    }

    FeatureEntry createFeatureEntry(ResultSet rs) throws SQLException, IOException {
        FeatureEntry e = new FeatureEntry();
        GeoPackage.initEntry(e, rs);
        e.setGeometryColumn(rs.getString("column_name"));
        e.setGeometryType(Geometries.getForName(rs.getString("geometry_type_name")));
        e.setZ(rs.getBoolean("z"));
        e.setM(rs.getBoolean("m"));
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGeoPackageContentsEntry(Entry e) throws IOException {
        this.addCRS(e.getSrid());
        StringBuilder sb = new StringBuilder();
        StringBuilder vals = new StringBuilder();
        sb.append(String.format("INSERT INTO %s (table_name, data_type, identifier", GEOPACKAGE_CONTENTS));
        vals.append("VALUES (?,?,?");
        if (e.getDescription() != null) {
            sb.append(", description");
            vals.append(",?");
        }
        if (e.getLastChange() != null) {
            sb.append(", last_change");
            vals.append(",?");
        }
        sb.append(", min_x, min_y, max_x, max_y");
        vals.append(",?,?,?,?");
        if (e.getSrid() != null) {
            sb.append(", srs_id");
            vals.append(",?");
        }
        sb.append(") ").append(vals.append(")").toString());
        try {
            Connection cx = this.connPool.getConnection();
            try {
                SqlUtil.PreparedStatementBuilder psb = SqlUtil.prepare((Connection)cx, (String)sb.toString()).set(e.getTableName()).set(e.getDataType().value()).set(e.getIdentifier());
                if (e.getDescription() != null) {
                    psb.set(e.getDescription());
                }
                if (e.getLastChange() != null) {
                    psb.set(DATE_FORMAT.format(e.getLastChange()));
                }
                if (e.getBounds() != null) {
                    psb.set(Double.valueOf(e.getBounds().getMinX())).set(Double.valueOf(e.getBounds().getMinY())).set(Double.valueOf(e.getBounds().getMaxX())).set(Double.valueOf(e.getBounds().getMaxY()));
                } else {
                    Envelope env;
                    CoordinateReferenceSystem crs;
                    double minx = 0.0;
                    double miny = 0.0;
                    double maxx = 0.0;
                    double maxy = 0.0;
                    if (e.getSrid() != null && (crs = this.getCRS(e.getSrid())) != null && (env = CRS.getEnvelope((CoordinateReferenceSystem)crs)) != null) {
                        minx = env.getMinimum(0);
                        miny = env.getMinimum(1);
                        maxx = env.getMaximum(0);
                        maxy = env.getMaximum(1);
                    }
                    psb.set(Double.valueOf(minx)).set(Double.valueOf(miny)).set(Double.valueOf(maxx)).set(Double.valueOf(maxy));
                }
                if (e.getSrid() != null) {
                    psb.set(e.getSrid());
                }
                PreparedStatement ps = psb.log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGeoPackageContentsEntry(Entry e) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE table_name = ?", GEOPACKAGE_CONTENTS);
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)sql).set(e.getTableName()).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGeometryColumnsEntry(FeatureEntry e) throws IOException {
        String sql = String.format("INSERT INTO %s VALUES (?, ?, ?, ?, ?, ?);", GEOMETRY_COLUMNS);
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)sql).set(e.getTableName()).set(e.getGeometryColumn()).set(e.getGeometryType() != null ? e.getGeometryType().getName() : null).set(e.getSrid()).set(Boolean.valueOf(e.isZ())).set(Boolean.valueOf(e.isM())).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGeometryColumnsEntry(FeatureEntry e) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE table_name = ?", GEOMETRY_COLUMNS);
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)sql).set(e.getTableName()).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSpatialIndex(FeatureEntry e) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        PrimaryKey pk = ((JDBCFeatureStore)this.dataStore.getFeatureSource(e.getTableName())).getPrimaryKey();
        if (pk.getColumns().size() != 1) {
            throw new IOException("Spatial index only supported for primary key of single column.");
        }
        properties.put("t", e.getTableName());
        properties.put("c", e.getGeometryColumn());
        properties.put("i", ((PrimaryKeyColumn)pk.getColumns().get(0)).getName());
        try (Connection cx = this.connPool.getConnection();){
            this.runScript("gpkg_spatial_index.sql", cx, properties);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RasterEntry> rasters() throws IOException {
        ArrayList<RasterEntry> arrayList;
        Connection cx = this.connPool.getConnection();
        try {
            ArrayList<RasterEntry> entries = new ArrayList<RasterEntry>();
            String sql = String.format("SELECT a.*, b.column_name, b.name, b.title, b.mime_type, b.description column_description, b.constraint_name, c.organization_coordsys_id, c.definition FROM %s a, %s b, %s c WHERE a.table_name = b.table_name AND a.srs_id = c.srs_id  AND a.data_type = ?", GEOPACKAGE_CONTENTS, RASTER_COLUMNS, SPATIAL_REF_SYS);
            PreparedStatement ps = cx.prepareStatement(sql);
            try {
                ps.setString(1, DataType.Raster.value());
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        entries.add(this.createRasterEntry(rs));
                    }
                }
                finally {
                    GeoPackage.close(rs);
                }
            }
            finally {
                GeoPackage.close(ps);
            }
            arrayList = entries;
        }
        catch (Throwable throwable) {
            try {
                GeoPackage.close(cx);
                throw throwable;
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        GeoPackage.close(cx);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RasterEntry raster(String name) throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                String sql = String.format("SELECT a.*, b.name, b.title, b.mime_type, b.column_name, b.description column_description, b.constraint_name, c.organization_coordsys_id, c.definition FROM %s a, %s b, %s c WHERE a.table_name = b.table_name AND a.srs_id = c.srs_id AND a.table_name = ? AND a.data_type = ?", GEOPACKAGE_CONTENTS, RASTER_COLUMNS, SPATIAL_REF_SYS);
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setString(1, name);
                    ps.setString(2, DataType.Raster.value());
                    ResultSet rs = ps.executeQuery();
                    try {
                        if (!rs.next()) return null;
                        RasterEntry rasterEntry = this.createRasterEntry(rs);
                        return rasterEntry;
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RasterEntry entry, GridCoverage2D raster, AbstractGridFormat format) throws IOException {
        RasterEntry e = new RasterEntry();
        e.init(entry);
        if (e.getTableName() == null) {
            if (raster.getName() == null) {
                throw new IllegalArgumentException("No table name specified for raster");
            }
            e.setTableName(raster.getName().toString());
        }
        if (e.getRasterColumn() == null) {
            e.setRasterColumn("raster");
        }
        if (e.getSrid() == null) {
            try {
                e.setSrid(GeoPackage.findSRID(raster));
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (e.getSrid() == null) {
            throw new IllegalArgumentException("Entry must have srid");
        }
        if (e.getBounds() == null) {
            e.setBounds(GeoPackage.findBounds(raster));
        }
        if (e.getBounds() == null) {
            throw new IllegalArgumentException("Entry must have bounds");
        }
        if (e.getIdentifier() == null) {
            e.setIdentifier(raster.getName().toString());
        }
        if (e.getDescription() == null) {
            e.setDescription(e.getIdentifier());
        }
        e.setLastChange(new Date());
        File tmpFile = File.createTempFile(e.getTableName(), "raster");
        GridCoverageWriter writer = format.getWriter(tmpFile);
        writer.write((GridCoverage)raster, null);
        writer.dispose();
        try {
            Connection cx = this.connPool.getConnection();
            try {
                Statement st = cx.createStatement();
                try {
                    String sql = String.format("CREATE TABLE %s (id INTEGER PRIMARY KEY AUTOINCREMENT, %s BLOB NOT NULL)", e.getTableName(), e.getRasterColumn());
                    LOGGER.fine(sql);
                    st.execute(sql);
                }
                finally {
                    GeoPackage.close(st);
                }
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(tmpFile));
                byte[] blob = IOUtils.toByteArray((InputStream)bin);
                try {
                    PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT INTO %s (%s) VALUES (?)", e.getTableName(), e.getRasterColumn())).set(blob).log(Level.FINE).statement();
                    try {
                        ps.execute();
                    }
                    finally {
                        GeoPackage.close(ps);
                    }
                }
                finally {
                    bin.close();
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        tmpFile.delete();
        this.addGeoPackageContentsEntry(e);
        this.addRasterColumnsEntry(e);
        entry.init(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GridCoverageReader reader(RasterEntry entry, AbstractGridFormat format) throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                Statement st = cx.createStatement();
                try {
                    ResultSet rs = st.executeQuery(String.format("SELECT %s FROM %s;", entry.getRasterColumn(), entry.getTableName()));
                    try {
                        if (!rs.next()) return null;
                        byte[] blob = rs.getBytes(1);
                        Hints hints = new Hints();
                        AbstractGridCoverage2DReader abstractGridCoverage2DReader = format.getReader(blob, hints);
                        return abstractGridCoverage2DReader;
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(st);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    static Integer findSRID(GridCoverage2D raster) throws Exception {
        return CRS.lookupEpsgCode((CoordinateReferenceSystem)raster.getCoordinateReferenceSystem(), (boolean)true);
    }

    static ReferencedEnvelope findBounds(GridCoverage2D raster) {
        Envelope e = raster.getEnvelope();
        return new ReferencedEnvelope(e.getMinimum(0), e.getMaximum(0), e.getMinimum(1), e.getMaximum(1), raster.getCoordinateReferenceSystem());
    }

    static GeneralEnvelope toGeneralEnvelope(ReferencedEnvelope e) {
        GeneralEnvelope ge = new GeneralEnvelope(new double[]{e.getMinX(), e.getMinY()}, new double[]{e.getMaxX(), e.getMaxY()});
        ge.setCoordinateReferenceSystem(e.getCoordinateReferenceSystem());
        return ge;
    }

    RasterEntry createRasterEntry(ResultSet rs) throws SQLException, IOException {
        RasterEntry e = new RasterEntry();
        GeoPackage.initEntry(e, rs);
        e.setRasterColumn(rs.getString("column_name"));
        e.setName(rs.getString("name"));
        e.setTitle(rs.getString("title"));
        e.setDescription(rs.getString("column_description"));
        e.setMimeType(rs.getString("mime_type"));
        e.setConstraint(rs.getString("constraint_name"));
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRasterColumnsEntry(RasterEntry e) throws IOException {
        String sql = String.format("INSERT INTO %s VALUES (?, ?, ?, ?, ?, ?, ?);", RASTER_COLUMNS);
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)sql).set(e.getTableName()).set(e.getRasterColumn()).set(e.getName()).set(e.getTitle()).set(e.getDescription()).set(e.getMimeType()).set(e.getConstraint()).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TileEntry> tiles() throws IOException {
        ArrayList<TileEntry> arrayList;
        Connection cx = this.connPool.getConnection();
        try {
            ArrayList<TileEntry> entries = new ArrayList<TileEntry>();
            String sql = String.format("SELECT a.*, c.organization_coordsys_id, c.definition FROM %s a, %s c WHERE a.srs_id = c.srs_id AND a.data_type = ?", GEOPACKAGE_CONTENTS, SPATIAL_REF_SYS);
            LOGGER.fine(sql);
            PreparedStatement ps = cx.prepareStatement(sql);
            try {
                ps.setString(1, DataType.Tile.value());
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        entries.add(GeoPackage.createTileEntry(rs, cx));
                    }
                }
                finally {
                    GeoPackage.close(rs);
                }
            }
            finally {
                GeoPackage.close(ps);
            }
            arrayList = entries;
        }
        catch (Throwable throwable) {
            try {
                GeoPackage.close(cx);
                throw throwable;
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        GeoPackage.close(cx);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TileEntry tile(String name) throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                String sql = String.format("SELECT a.*, c.organization_coordsys_id, c.definition FROM %s a, %s c WHERE a.srs_id = c.srs_id AND a.table_name = ? AND a.data_type = ?", GEOPACKAGE_CONTENTS, SPATIAL_REF_SYS);
                LOGGER.fine(sql);
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setString(1, name);
                    ps.setString(2, DataType.Tile.value());
                    ResultSet rs = ps.executeQuery();
                    try {
                        if (!rs.next()) return null;
                        TileEntry tileEntry = GeoPackage.createTileEntry(rs, cx);
                        return tileEntry;
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(TileEntry entry) throws IOException {
        if (entry.getBounds() == null) {
            throw new IllegalArgumentException("Tile entry must specify bounds");
        }
        TileEntry e = new TileEntry();
        e.init(entry);
        if (e.getTableName() == null) {
            e.setTableName("tiles");
        }
        if (e.getIdentifier() == null) {
            e.setIdentifier(e.getTableName());
        }
        if (e.getDescription() == null) {
            e.setDescription(e.getIdentifier());
        }
        if (e.getSrid() == null) {
            try {
                e.setSrid(GeoPackage.findSRID(entry.getBounds()));
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        e.setLastChange(new Date());
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement st = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT INTO %s VALUES (?,?,?,?,?,?)", TILE_MATRIX_SET)).set(e.getTableName()).set(e.getSrid()).set(Double.valueOf(e.getBounds().getMinX())).set(Double.valueOf(e.getBounds().getMinY())).set(Double.valueOf(e.getBounds().getMaxX())).set(Double.valueOf(e.getBounds().getMaxY())).statement();
                try {
                    st.execute();
                }
                finally {
                    GeoPackage.close(st);
                }
                st = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT INTO %s VALUES (?,?,?,?,?,?,?,?)", TILE_MATRIX_METADATA)).statement();
                try {
                    for (TileMatrix m : e.getTileMatricies()) {
                        SqlUtil.prepare((PreparedStatement)st).set(e.getTableName()).set(m.getZoomLevel()).set(m.getMatrixWidth()).set(m.getMatrixHeight()).set(m.getTileWidth()).set(m.getTileHeight()).set(m.getXPixelSize()).set(m.getYPixelSize()).statement().execute();
                    }
                }
                finally {
                    GeoPackage.close(st);
                }
                st = cx.prepareStatement(String.format("CREATE TABLE %s (id INTEGER PRIMARY KEY AUTOINCREMENT,zoom_level INTEGER NOT NULL DEFAULT 0,tile_column INTEGER NOT NULL DEFAULT 0,tile_row INTEGER NOT NULL DEFAULT 0,tile_data BLOB NOT NULL DEFAULT (zeroblob(4)))", e.getTableName()));
                try {
                    st.execute();
                }
                finally {
                    GeoPackage.close(st);
                }
                st = cx.prepareStatement(String.format("create index %s_zyx_idx on %s(zoom_level, tile_column, tile_row);", e.getTableName(), e.getTableName()));
                try {
                    st.execute();
                }
                finally {
                    GeoPackage.close(st);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        this.addGeoPackageContentsEntry(e);
        entry.init(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TileEntry entry, Tile tile) throws IOException {
        try {
            Connection cx = this.connPool.getConnection();
            try {
                PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("INSERT INTO %s (zoom_level, tile_column, tile_row, tile_data) VALUES (?,?,?,?)", entry.getTableName())).set(tile.getZoom()).set(tile.getColumn()).set(tile.getRow()).set(tile.getData()).log(Level.FINE).statement();
                try {
                    ps.execute();
                }
                finally {
                    GeoPackage.close(ps);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public TileReader reader(TileEntry entry, Integer lowZoom, Integer highZoom, Integer lowCol, Integer highCol, Integer lowRow, Integer highRow) throws IOException {
        try {
            ArrayList<String> q = new ArrayList<String>();
            if (lowZoom != null) {
                q.add("zoom_level >= " + lowZoom);
            }
            if (highZoom != null) {
                q.add("zoom_level <= " + highZoom);
            }
            if (lowCol != null) {
                q.add("tile_column >= " + lowCol);
            }
            if (highCol != null) {
                q.add("tile_column <= " + highCol);
            }
            if (lowRow != null) {
                q.add("tile_row >= " + lowRow);
            }
            if (highRow != null) {
                q.add("tile_row <= " + highRow);
            }
            StringBuffer sql = new StringBuffer("SELECT * FROM ").append(entry.getTableName());
            if (!q.isEmpty()) {
                sql.append(" WHERE ");
                for (String s : q) {
                    sql.append(s).append(" AND ");
                }
                sql.setLength(sql.length() - 5);
            }
            Connection cx = this.connPool.getConnection();
            Statement st = cx.createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            return new TileReader(rs, cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected String getSpatialIndexName(FeatureEntry entry) {
        return "rtree_" + entry.getTableName() + "_" + entry.getGeometryColumn();
    }

    /*
     * Exception decompiling
     */
    public boolean hasSpatialIndex(FeatureEntry entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Set<Identifier> searchSpatialIndex(FeatureEntry entry, Double minX, Double minY, Double maxX, Double maxY) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTileBound(TileEntry entry, int zoom, boolean isMax, boolean isRow) throws IOException {
        try {
            int tileBounds = -1;
            StringBuffer sql = new StringBuffer("SELECT " + (isMax ? "MAX" : "MIN") + "( " + (isRow ? "tile_row" : "tile_column") + ") FROM ");
            sql.append(entry.getTableName());
            sql.append(" WHERE zoom_level == ");
            sql.append(zoom);
            Connection cx = this.connPool.getConnection();
            try {
                Statement st = cx.createStatement();
                try {
                    ResultSet rs = st.executeQuery(sql.toString());
                    try {
                        rs.next();
                        tileBounds = rs.getInt(1);
                    }
                    finally {
                        GeoPackage.close(rs);
                    }
                }
                finally {
                    GeoPackage.close(st);
                }
            }
            finally {
                GeoPackage.close(cx);
            }
            return tileBounds;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TileEntry createTileEntry(ResultSet rs, Connection cx) throws SQLException, IOException {
        TileEntry e = new TileEntry();
        GeoPackage.initEntry(e, rs);
        PreparedStatement psm = cx.prepareStatement(String.format("SELECT * FROM %s WHERE table_name = ? ORDER BY zoom_level ASC", TILE_MATRIX_METADATA));
        try {
            psm.setString(1, e.getTableName());
            ResultSet rsm = psm.executeQuery();
            try {
                while (rsm.next()) {
                    TileMatrix m = new TileMatrix();
                    m.setZoomLevel(rsm.getInt("zoom_level"));
                    m.setMatrixWidth(rsm.getInt("matrix_width"));
                    m.setMatrixHeight(rsm.getInt("matrix_height"));
                    m.setTileWidth(rsm.getInt("tile_width"));
                    m.setTileHeight(rsm.getInt("tile_height"));
                    m.setXPixelSize(rsm.getDouble("pixel_x_size"));
                    m.setYPixelSize(rsm.getDouble("pixel_y_size"));
                    e.getTileMatricies().add(m);
                }
            }
            finally {
                GeoPackage.close(rsm);
            }
        }
        finally {
            GeoPackage.close(psm);
        }
        return e;
    }

    static Integer findSRID(ReferencedEnvelope e) throws Exception {
        return CRS.lookupEpsgCode((CoordinateReferenceSystem)e.getCoordinateReferenceSystem(), (boolean)true);
    }

    static void initEntry(Entry e, ResultSet rs) throws SQLException, IOException {
        CoordinateReferenceSystem crs;
        e.setIdentifier(rs.getString("identifier"));
        e.setDescription(rs.getString("description"));
        e.setTableName(rs.getString("table_name"));
        try {
            e.setLastChange(DATE_FORMAT.parse(rs.getString("last_change")));
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
        int srid = rs.getInt("organization_coordsys_id");
        e.setSrid(srid);
        try {
            crs = CRS.decode((String)("EPSG:" + srid));
        }
        catch (Exception ex) {
            try {
                crs = CRS.parseWKT((String)rs.getString("srtext"));
            }
            catch (Exception e2) {
                throw new IOException(ex);
            }
        }
        e.setBounds(new ReferencedEnvelope(rs.getDouble("min_x"), rs.getDouble("max_x"), rs.getDouble("min_y"), rs.getDouble("max_y"), crs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runSQL(String sql, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            st.execute(sql);
        }
        finally {
            GeoPackage.close(st);
        }
    }

    void runScript(String filename, Connection cx) throws SQLException {
        SqlUtil.runScript((InputStream)this.getClass().getResourceAsStream(filename), (Connection)cx);
    }

    void runScript(String filename, Connection cx, Map<String, String> properties) throws SQLException {
        SqlUtil.runScript((InputStream)this.getClass().getResourceAsStream(filename), (Connection)cx, properties);
    }

    private static void close(Connection cx) {
        if (cx != null) {
            try {
                cx.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error closing connection", e);
            }
        }
    }

    private static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error closing statement", e);
            }
        }
    }

    private static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error closing resultset", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JDBCDataStore dataStore() throws IOException {
        if (this.dataStore == null) {
            GeoPackage geoPackage = this;
            synchronized (geoPackage) {
                if (this.dataStore == null) {
                    this.dataStore = this.createDataStore();
                }
            }
        }
        return this.dataStore;
    }

    JDBCDataStore createDataStore() throws IOException {
        HashMap<String, DataSource> params = new HashMap<String, DataSource>();
        params.put(GeoPkgDataStoreFactory.DATASOURCE.key, this.connPool);
        return new GeoPkgDataStoreFactory(this.writerConfig).createDataStore(params);
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static enum DataType {
        Feature("features"),
        Raster("rasters"),
        Tile("tiles"),
        FeatureWithRaster("featuresWithRasters");

        String value;

        private DataType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

