/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.postgis.PostGISPSDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.KVP;

public class PostgisNGDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"postgis");
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extends", Boolean.class, "Use the spatial index information to quickly get an estimate of the data bounds", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)5432);
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "Schema", false, (Object)"public");
    public static final DataAccessFactory.Param CREATE_DB_IF_MISSING = new DataAccessFactory.Param("create database", Boolean.class, "Creates the database if it does not exist yet", false, (Object)false, new Object[]{"level", "advanced"});
    public static final DataAccessFactory.Param CREATE_PARAMS = new DataAccessFactory.Param("create database params", String.class, "Extra specifications appeneded to the CREATE DATABASE command", false, (Object)"", new Object[]{"level", "advanced"});
    public static final DataAccessFactory.Param PREPARED_STATEMENTS = new DataAccessFactory.Param("preparedStatements", Boolean.class, "Use prepared statements", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param ENCODE_FUNCTIONS = new DataAccessFactory.Param("encode functions", Boolean.class, "set to true to have a set of filter functions be translated directly in SQL. Due to differences in the type systems the result might not be the same as evaluating them in memory, including the SQL failing with errors while the in memory version works fine. However this allows to push more of the filter into the database, increasing performance.the postgis table.", false, (Object)new Boolean(false), (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param SIMPLIFY = new DataAccessFactory.Param("Support on the fly geometry simplification", Boolean.class, "When enabled, operations such as map rendering will pass a hint that will enable the usage of ST_Simplify", false, (Object)Boolean.TRUE);

    @Override
    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new PostGISDialect(dataStore);
    }

    @Override
    protected String getDatabaseID() {
        return (String)PostgisNGDataStoreFactory.DBTYPE.sample;
    }

    @Override
    public String getDisplayName() {
        return "PostGIS";
    }

    public String getDescription() {
        return "PostGIS Database";
    }

    @Override
    protected String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    protected boolean checkDBType(Map params) {
        if (super.checkDBType(params)) {
            try {
                Class.forName("org.geotools.data.postgis.PostgisDataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return this.checkDBType(params, "postgisng");
    }

    @Override
    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        Boolean simplify;
        PostGISDialect dialect = (PostGISDialect)dataStore.getSQLDialect();
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated == null || Boolean.TRUE.equals(estimated));
        Boolean encodeFunctions = (Boolean)ENCODE_FUNCTIONS.lookUp(params);
        dialect.setFunctionEncodingEnabled(encodeFunctions != null && encodeFunctions != false);
        Boolean usePs = (Boolean)PREPARED_STATEMENTS.lookUp(params);
        if (Boolean.TRUE.equals(usePs)) {
            dataStore.setSQLDialect(new PostGISPSDialect(dataStore, dialect));
        }
        dialect.setSimplifyEnabled((simplify = (Boolean)SIMPLIFY.lookUp(params)) == null || simplify != false);
        return dataStore;
    }

    @Override
    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(PostgisNGDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(PostgisNGDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(PostgisNGDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(PostgisNGDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
        parameters.put(PostgisNGDataStoreFactory.PORT.key, PORT);
        parameters.put(PostgisNGDataStoreFactory.PREPARED_STATEMENTS.key, PREPARED_STATEMENTS);
        parameters.put(PostgisNGDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
        parameters.put(PostgisNGDataStoreFactory.ENCODE_FUNCTIONS.key, ENCODE_FUNCTIONS);
        parameters.put(PostgisNGDataStoreFactory.SIMPLIFY.key, SIMPLIFY);
        parameters.put(PostgisNGDataStoreFactory.CREATE_DB_IF_MISSING.key, CREATE_DB_IF_MISSING);
        parameters.put(PostgisNGDataStoreFactory.CREATE_PARAMS.key, CREATE_PARAMS);
    }

    @Override
    protected String getValidationQuery() {
        return "select now()";
    }

    @Override
    protected String getJDBCUrl(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        return "jdbc:postgresql://" + host + ":" + port + "/" + db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSource createDataSource(Map params, SQLDialect dialect) throws IOException {
        DataSource ds = super.createDataSource(params, dialect);
        JDBCDataStore closer = new JDBCDataStore();
        if (Boolean.TRUE.equals(CREATE_DB_IF_MISSING.lookUp(params))) {
            Connection cx = null;
            boolean canConnect = true;
            try {
                cx = ds.getConnection();
            }
            catch (SQLException e) {
                canConnect = false;
            }
            finally {
                closer.closeSafe(cx);
            }
            if (!canConnect) {
                String host = (String)HOST.lookUp(params);
                int port = (Integer)PORT.lookUp(params);
                String db = (String)DATABASE.lookUp(params);
                String user = (String)USER.lookUp(params);
                String password = (String)PASSWD.lookUp(params);
                Statement st = null;
                try {
                    String url = "jdbc:postgresql://" + host + ":" + port + "/template1";
                    cx = this.getConnection(user, password, url);
                    String createParams = (String)CREATE_PARAMS.lookUp(params);
                    String sql = "CREATE DATABASE \"" + db + "\" " + (createParams == null ? "" : createParams);
                    st = cx.createStatement();
                    st.execute(sql);
                    closer.closeSafe(st);
                    closer.closeSafe(cx);
                }
                catch (SQLException e) {
                    try {
                        throw new IOException("Failed to create the target database", e);
                    }
                    catch (Throwable throwable) {
                        closer.closeSafe(st);
                        closer.closeSafe(cx);
                        throw throwable;
                    }
                }
                ResultSet rs = null;
                try {
                    String url = "jdbc:postgresql://" + host + ":" + port + "/" + db;
                    cx = DriverManager.getConnection(url, user, password);
                    st = cx.createStatement();
                    try {
                        rs = st.executeQuery("select PostGIS_version()");
                        rs.close();
                    }
                    catch (SQLException e) {
                        st.execute("create extension postgis");
                    }
                }
                catch (SQLException e) {
                    throw new IOException("Failed to create the target database", e);
                }
                finally {
                    closer.closeSafe(st);
                    closer.closeSafe(cx);
                }
                ds = super.createDataSource(params, dialect);
            }
        }
        return ds;
    }

    private Connection getConnection(String user, String password, String url) throws SQLException {
        Connection cx = user != null ? DriverManager.getConnection(url, user, password) : DriverManager.getConnection(url);
        return cx;
    }

    public void dropDatabase(Map<String, Object> params) throws IOException {
        JDBCDataStore closer = new JDBCDataStore();
        String host = (String)HOST.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        String user = (String)USER.lookUp(params);
        String password = (String)PASSWD.lookUp(params);
        Connection cx = null;
        Statement st = null;
        try {
            String url = "jdbc:postgresql://" + host + ":" + port + "/template1";
            cx = this.getConnection(user, password, url);
            String sql = "DROP DATABASE \"" + db + "\"";
            st = cx.createStatement();
            st.execute(sql);
            closer.closeSafe(st);
            closer.closeSafe(cx);
        }
        catch (SQLException e) {
            try {
                throw new IOException("Failed to drop the target database", e);
            }
            catch (Throwable throwable) {
                closer.closeSafe(st);
                closer.closeSafe(cx);
                throw throwable;
            }
        }
    }
}

