/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.geometry.Envelope;

public class MBTilesMetadata {
    protected static Pattern patternEnvelope = Pattern.compile(" *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *, *(\\-?[0-9\\.]*) *");
    protected String name;
    protected String version;
    protected String description;
    protected t_type type;
    protected t_format format;
    protected Envelope bounds;
    protected String attribution;
    protected int minZoom;
    protected int maxZoom;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public t_type getType() {
        return this.type;
    }

    public void setType(t_type type) {
        this.type = type;
    }

    public t_format getFormat() {
        return this.format;
    }

    public void setFormat(t_format format) {
        this.format = format;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public void setBounds(Envelope bounds) {
        this.bounds = bounds;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public String getTypeStr() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString().toLowerCase();
    }

    public String getFormatStr() {
        if (this.format == null) {
            return null;
        }
        return this.format.toString().toLowerCase();
    }

    public String getBoundsStr() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getMinimum(0) + "," + this.bounds.getMinimum(1) + "," + this.bounds.getMaximum(0) + "," + this.bounds.getMaximum(1);
    }

    public void setTypeStr(String typeStr) {
        if (typeStr == null) {
            this.setType(null);
        } else {
            this.setType(t_type.valueOf(typeStr.toUpperCase()));
        }
    }

    public void setFormatStr(String formatStr) {
        if (formatStr == null) {
            this.setFormat(null);
        } else {
            this.setFormat(t_format.valueOf(formatStr.toUpperCase()));
        }
    }

    public void setBoundsStr(String boundsStr) {
        if (boundsStr == null) {
            this.setBounds(null);
        } else {
            Matcher matcherEnvelope = patternEnvelope.matcher(boundsStr);
            if (!matcherEnvelope.matches()) {
                throw new IllegalArgumentException("Envelope not in correct format: minx,miny,maxx,maxy");
            }
            double minx = Double.parseDouble(matcherEnvelope.group(1));
            double miny = Double.parseDouble(matcherEnvelope.group(2));
            double maxx = Double.parseDouble(matcherEnvelope.group(3));
            double maxy = Double.parseDouble(matcherEnvelope.group(4));
            this.setBounds(new ReferencedEnvelope(minx, maxx, miny, maxy, null));
        }
    }

    public void setMinZoomStr(String minZoomStr) {
        this.minZoom = minZoomStr == null ? 0 : Integer.parseInt(minZoomStr);
    }

    public void setMaxZoomStr(String maxZoomStr) {
        this.maxZoom = maxZoomStr == null ? 0 : Integer.parseInt(maxZoomStr);
    }

    public static enum t_format {
        JPEG,
        PNG;

    }

    public static enum t_type {
        OVERLAY,
        BASE_LAYER;

    }
}

