/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.mbtiles.MBTilesDataStoreFactory;
import org.geotools.mbtiles.MBTilesGrid;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.sql.SqlUtil;
import org.geotools.util.logging.Logging;

public class MBTilesFile {
    public static final String PRAGMA_JOURNAL_MODE_OFF = "PRAGMA journal_mode=OFF";
    protected final String TABLE_METADATA = "metadata";
    protected final String TABLE_TILES = "tiles";
    protected final String TABLE_GRIDS = "grids";
    protected final String TABLE_GRID_DATA = "grid_data";
    protected final String MD_NAME = "name";
    protected final String MD_TYPE = "type";
    protected final String MD_VERSION = "version";
    protected final String MD_DESCRIPTION = "description";
    protected final String MD_FORMAT = "format";
    protected final String MD_BOUNDS = "bounds";
    protected final String MD_ATTRIBUTION = "attribution";
    protected final String MD_MINZOOM = "minzoom";
    protected final String MD_MAXZOOM = "maxzoom";
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.mbtiles");
    protected File file;
    protected final DataSource connPool;
    protected volatile JDBCDataStore dataStore;
    protected boolean disableJournal;

    public MBTilesFile() throws IOException {
        this(File.createTempFile("temp", ".mbtiles"));
    }

    public MBTilesFile(boolean disableJournal) throws IOException {
        this(File.createTempFile("temp", ".mbtiles"), disableJournal);
    }

    public MBTilesFile(File file) throws IOException {
        this(file, null, null, false);
    }

    public MBTilesFile(File file, boolean disableJournal) throws IOException {
        this(file, null, null, disableJournal);
    }

    public MBTilesFile(File file, String user, String passwd, boolean disableJournal) throws IOException {
        this.file = file;
        this.disableJournal = disableJournal;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (user != null) {
            params.put(MBTilesDataStoreFactory.USER.key, user);
        }
        if (passwd != null) {
            params.put(MBTilesDataStoreFactory.PASSWD.key, passwd);
        }
        params.put(MBTilesDataStoreFactory.DATABASE.key, file.getPath());
        params.put(MBTilesDataStoreFactory.DBTYPE.key, MBTilesDataStoreFactory.DBTYPE.sample);
        this.connPool = new MBTilesDataStoreFactory().createDataSource(params);
    }

    MBTilesFile(DataSource dataSource) {
        this.connPool = dataSource;
    }

    MBTilesFile(JDBCDataStore dataStore) {
        this.dataStore = dataStore;
        this.connPool = dataStore.getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetaData(MBTilesMetadata metaData) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.saveMetaDataEntry("name", metaData.getName(), cx);
            this.saveMetaDataEntry("version", metaData.getVersion(), cx);
            this.saveMetaDataEntry("description", metaData.getDescription(), cx);
            this.saveMetaDataEntry("attribution", metaData.getAttribution(), cx);
            this.saveMetaDataEntry("type", metaData.getTypeStr(), cx);
            this.saveMetaDataEntry("format", metaData.getFormatStr(), cx);
            this.saveMetaDataEntry("bounds", metaData.getBoundsStr(), cx);
            this.saveMetaDataEntry("minzoom", String.valueOf(metaData.getMinZoom()), cx);
            this.saveMetaDataEntry("maxzoom", String.valueOf(metaData.getMaxZoom()), cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMinMaxZoomMetadata(int min, int max) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.saveMetaDataEntry("minzoom", String.valueOf(min), cx);
            this.saveMetaDataEntry("maxzoom", String.valueOf(max), cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTile(MBTilesTile entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            if (this.disableJournal) {
                this.disableJournal(cx);
            }
            PreparedStatement ps = entry.getData() != null ? SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?,?,?)", "tiles")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(entry.getData()).log(Level.FINE).statement() : SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "tiles")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            ps.execute();
            ps.close();
            this.saveMinMaxZoomMetadata((int)Math.min(entry.getZoomLevel(), this.minZoom()), (int)Math.max(entry.getZoomLevel(), this.maxZoom()));
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGrid(MBTilesGrid entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = entry.getGrid() != null ? SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?,?,?)", "grids")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(entry.getGrid()).log(Level.FINE).statement() : SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "grids")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            ps.execute();
            ps.close();
            for (Map.Entry<String, String> gridDataEntry : entry.getGridData().entrySet()) {
                ps = gridDataEntry.getValue() != null ? SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?,?,?,?)", "grid_data")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(gridDataEntry.getKey()).set(gridDataEntry.getValue()).log(Level.FINE).statement() : SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=? AND key_name=?", "grid_data")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).set(gridDataEntry.getKey()).log(Level.FINE).statement();
                ps.execute();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public MBTilesMetadata loadMetaData() throws IOException {
        return this.loadMetaData(new MBTilesMetadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBTilesMetadata loadMetaData(MBTilesMetadata metaData) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            metaData.setName(this.loadMetaDataEntry("name", cx));
            metaData.setVersion(this.loadMetaDataEntry("version", cx));
            metaData.setDescription(this.loadMetaDataEntry("description", cx));
            metaData.setAttribution(this.loadMetaDataEntry("attribution", cx));
            metaData.setTypeStr(this.loadMetaDataEntry("type", cx));
            metaData.setFormatStr(this.loadMetaDataEntry("format", cx));
            metaData.setBoundsStr(this.loadMetaDataEntry("bounds", cx));
            metaData.setMinZoomStr(this.loadMetaDataEntry("minzoom", cx));
            metaData.setMaxZoomStr(this.loadMetaDataEntry("maxzoom", cx));
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return metaData;
    }

    public MBTilesTile loadTile(long zoomLevel, long column, long row) throws IOException {
        return this.loadTile(new MBTilesTile(zoomLevel, column, row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBTilesTile loadTile(MBTilesTile entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT tile_data FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "tiles")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                entry.setData(rs.getBytes(1));
            } else {
                entry.setData(null);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return entry;
    }

    public MBTilesGrid loadGrid(long zoomLevel, long column, long row) throws IOException {
        return this.loadGrid(new MBTilesGrid(zoomLevel, column, row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBTilesGrid loadGrid(MBTilesGrid entry) throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT grid FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "grids")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                entry.setGrid(rs.getBytes(1));
            } else {
                entry.setGrid(null);
            }
            rs.close();
            ps.close();
            ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT key_name, key_json FROM %s WHERE zoom_level=? AND tile_column=? AND tile_row=?", "grid_data")).set(Long.valueOf(entry.getZoomLevel())).set(Long.valueOf(entry.getTileColumn())).set(Long.valueOf(entry.getTileRow())).log(Level.FINE).statement();
            rs = ps.executeQuery();
            while (rs.next()) {
                entry.setGridDataKey(rs.getString(1), rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return entry;
    }

    public TileIterator tiles() throws SQLException {
        Connection cx = this.connPool.getConnection();
        Statement st = cx.createStatement();
        return new TileIterator(st.executeQuery("SELECT * FROM tiles;"));
    }

    public TileIterator tiles(long zoomLevel) throws SQLException {
        Connection cx = this.connPool.getConnection();
        PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT * FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
        return new TileIterator(ps.executeQuery());
    }

    public TileIterator tiles(long zoomLevel, long leftTile, long bottomTile, long rightTile, long topTile) throws SQLException {
        Connection cx = this.connPool.getConnection();
        PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT * FROM %s WHERE zoom_level=? AND tile_column >= ? AND tile_row >= ? AND tile_column <= ? AND tile_row <= ?", "tiles")).set(Long.valueOf(zoomLevel)).set(Long.valueOf(leftTile)).set(Long.valueOf(bottomTile)).set(Long.valueOf(rightTile)).set(Long.valueOf(topTile)).statement();
        return new TileIterator(ps.executeQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfTiles() throws SQLException {
        int size;
        try (Connection cx = this.connPool.getConnection();){
            Statement st = cx.createStatement();
            ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM tiles;");
            rs.next();
            size = rs.getInt(1);
            rs.close();
            st.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfTiles(long zoomLevel) throws SQLException {
        int size;
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT COUNT(*) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            ResultSet rs = ps.executeQuery();
            rs.next();
            size = rs.getInt(1);
            rs.close();
            ps.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long closestZoom(long zoomLevel) throws SQLException {
        long zoom = 0L;
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT zoom_level FROM %s ORDER BY abs(zoom_level - ?)", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                zoom = rs.getLong(1);
            }
            rs.close();
            ps.close();
        }
        return zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long minZoom() throws SQLException {
        long zoom = 0L;
        try (Connection cx = this.connPool.getConnection();){
            Statement st = cx.createStatement();
            ResultSet rs = st.executeQuery("SELECT MIN(zoom_level) FROM tiles");
            if (rs.next()) {
                zoom = rs.getLong(1);
            }
            rs.close();
            st.close();
        }
        return zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maxZoom() throws SQLException {
        long zoom = 0L;
        try (Connection cx = this.connPool.getConnection();){
            Statement st = cx.createStatement();
            ResultSet rs = st.executeQuery("SELECT MAX(zoom_level) FROM tiles");
            if (rs.next()) {
                zoom = rs.getLong(1);
            }
            rs.close();
            st.close();
        }
        return zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long minColumn(long zoomLevel) throws SQLException {
        long size = 0L;
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MIN(tile_column) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                size = rs.getLong(1);
            }
            rs.close();
            ps.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maxColumn(long zoomLevel) throws SQLException {
        long size = Long.MAX_VALUE;
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MAX(tile_column) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                size = rs.getLong(1);
            }
            rs.close();
            ps.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long minRow(long zoomLevel) throws SQLException {
        long size = 0L;
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MIN(tile_row) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            ResultSet rs = ps.executeQuery();
            rs.next();
            if (rs.next()) {
                size = rs.getLong(1);
            }
            rs.close();
            ps.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maxRow(long zoomLevel) throws SQLException {
        long size = Long.MAX_VALUE;
        try (Connection cx = this.connPool.getConnection();){
            PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT MAX(tile_row) FROM %s WHERE zoom_level=?", "tiles")).set(Long.valueOf(zoomLevel)).statement();
            ResultSet rs = ps.executeQuery();
            rs.next();
            size = rs.getLong(1);
            rs.close();
            ps.close();
        }
        return size;
    }

    public void close() {
        if (this.dataStore != null) {
            this.dataStore.dispose();
        }
        try {
            if (this.connPool instanceof BasicDataSource) {
                ((BasicDataSource)this.connPool).close();
            } else if (this.connPool instanceof ManageableDataSource) {
                ((ManageableDataSource)this.connPool).close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing database connection", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    protected void saveMetaDataEntry(String name, String value, Connection cx) throws SQLException {
        if (this.disableJournal) {
            this.disableJournal(cx);
        }
        PreparedStatement ps = value != null ? SqlUtil.prepare((Connection)cx, (String)String.format("INSERT OR REPLACE INTO %s VALUES (?,?)", "metadata")).set(name).set(value).log(Level.FINE).statement() : SqlUtil.prepare((Connection)cx, (String)String.format("DELETE FROM %s WHERE NAME = ?", "metadata")).set(name).log(Level.FINE).statement();
        ps.execute();
        ps.close();
    }

    protected String loadMetaDataEntry(String name, Connection cx) throws SQLException {
        PreparedStatement ps = SqlUtil.prepare((Connection)cx, (String)String.format("SELECT VALUE FROM %s WHERE NAME = ?", "metadata")).set(name).log(Level.FINE).statement();
        ResultSet rs = ps.executeQuery();
        String result = null;
        if (rs.next()) {
            result = rs.getString(1);
        }
        rs.close();
        ps.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        try (Connection cx = this.connPool.getConnection();){
            this.init(cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void init(Connection cx) throws SQLException {
        this.runScript("mbtiles.sql", cx);
    }

    protected void runScript(String filename, Connection cx) throws SQLException {
        SqlUtil.runScript((InputStream)this.getClass().getResourceAsStream(filename), (Connection)cx);
    }

    private void disableJournal(Connection cx) throws SQLException {
        try (PreparedStatement prepared = SqlUtil.prepare((Connection)cx, (String)PRAGMA_JOURNAL_MODE_OFF).statement();){
            prepared.execute();
        }
    }

    public class TileIterator
    implements Iterator<MBTilesTile>,
    Closeable {
        ResultSet rs;
        Boolean next = null;

        TileIterator(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.rs.next();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.next;
        }

        @Override
        public MBTilesTile next() {
            try {
                MBTilesTile entry = new MBTilesTile(this.rs.getLong(1), this.rs.getLong(2), this.rs.getLong(3));
                entry.setData(this.rs.getBytes(4));
                MBTilesTile mBTilesTile = entry;
                return mBTilesTile;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            try {
                Statement st = this.rs.getStatement();
                Connection conn = st.getConnection();
                this.rs.close();
                st.close();
                conn.close();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }
}

