/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.geotools.mbtiles.MBTilesDialect;
import org.sqlite.SQLiteConfig;

public class MBTilesDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"mbtiles");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);

    protected String getDatabaseID() {
        return "mbtiles";
    }

    public String getDescription() {
        return "MbTiles";
    }

    protected String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new MBTilesDialect(dataStore);
    }

    protected String getValidationQuery() {
        return "SELECT 1";
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String db = (String)DATABASE.lookUp(params);
        return "jdbc:sqlite:" + db;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(MBTilesDataStoreFactory.HOST.key);
        parameters.remove(MBTilesDataStoreFactory.PORT.key);
        parameters.remove(MBTilesDataStoreFactory.SCHEMA.key);
        parameters.remove(JDBCDataStoreFactory.USER.key);
        parameters.put(MBTilesDataStoreFactory.USER.key, USER);
        parameters.put(MBTilesDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    public BasicDataSource createDataSource(Map params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        MBTilesDataStoreFactory.addConnectionProperties(dataSource);
        return dataSource;
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        dataStore.setDatabaseSchema(null);
        return dataStore;
    }

    static void addConnectionProperties(BasicDataSource dataSource) {
        SQLiteConfig config = new SQLiteConfig();
        config.setSharedCache(true);
        config.enableLoadExtension(true);
        for (Map.Entry<Object, Object> e : config.toProperties().entrySet()) {
            dataSource.addConnectionProperty((String)e.getKey(), (String)e.getValue());
        }
    }
}

