/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

class SFSFilterVisitor
implements FilterVisitor {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.simplefeatureservice");
    private Map<String, String> properties = new HashMap<String, String>();
    private List<String> queryable = new ArrayList<String>();
    private boolean sortProperties;
    private boolean hasProperties;
    private static final String strEncoding = "UTF-8";

    public SFSFilterVisitor() {
    }

    public SFSFilterVisitor(boolean sortProperties) {
        this.sortProperties = sortProperties;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public void setSortProperties(boolean sortProperties) {
        this.sortProperties = sortProperties;
    }

    public String finish(StringBuilder builder, boolean hasProperties) throws UnsupportedEncodingException {
        this.hasProperties = hasProperties;
        ArrayList<String> props = new ArrayList<String>(this.properties.keySet());
        if (this.sortProperties) {
            Collections.sort(this.queryable);
            Collections.sort(props);
        }
        for (String property : props) {
            builder.append(this.getGlueChar());
            builder.append(URLEncoder.encode(property, strEncoding));
            builder.append("=");
            builder.append(URLEncoder.encode(this.properties.get(property), strEncoding));
        }
        if (this.queryable != null && this.queryable.size() > 0) {
            builder.append(this.getGlueChar());
            builder.append("queryable=");
            for (int i = 0; i < this.queryable.size(); ++i) {
                builder.append(URLEncoder.encode(this.queryable.get(i), strEncoding));
                if (i >= this.queryable.size() - 1) continue;
                builder.append(",");
            }
        }
        this.properties.clear();
        this.queryable.clear();
        return builder.toString();
    }

    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        throw new UnsupportedOperationException("visit (ExcludeFilter filter, Object extraData)");
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        for (Filter element : filter.getChildren()) {
            element.accept((FilterVisitor)this, extraData);
        }
        return extraData;
    }

    public Object visit(Id filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Not filter, Object extraData)");
    }

    public Object visit(Not filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Not filter, Object extraData)");
    }

    public Object visit(Or filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Or filter, Object extraData)");
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        throw new UnsupportedOperationException("visit (PropertyIsBetween filter, Object extraData)");
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        this.checkPropertyFilter(propertyName, "__eq", (BinaryComparisonOperator)filter);
        return extraData;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        this.checkPropertyFilter(propertyName, "__ne", (BinaryComparisonOperator)filter);
        return extraData;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        this.checkPropertyFilter(propertyName, "__gt", (BinaryComparisonOperator)filter);
        return extraData;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        this.checkPropertyFilter(propertyName, "__gte", (BinaryComparisonOperator)filter);
        return extraData;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        this.checkPropertyFilter(propertyName, "__lt", (BinaryComparisonOperator)filter);
        return extraData;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        String propertyName = ((PropertyName)filter.getExpression1()).getPropertyName();
        this.checkPropertyFilter(propertyName, "__lte", (BinaryComparisonOperator)filter);
        return extraData;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        String value;
        String operator;
        String propertyName = ((PropertyName)filter.getExpression()).getPropertyName();
        String string = operator = filter.isMatchingCase() ? "__like" : "__ilike";
        if (!this.properties.containsKey(propertyName + operator) && (value = filter.getLiteral()) != null) {
            this.properties.put(propertyName + operator, value);
            if (!this.queryable.contains(propertyName)) {
                this.queryable.add(propertyName);
            }
        }
        return extraData;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        throw new UnsupportedOperationException("visit (PropertyIsNull filter, Object extraData)");
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("visit(PropertyIsNil filter, Object extraData)");
    }

    public Object visit(BBOX filter, Object extraData) {
        Polygon polygon = (Polygon)filter.getExpression2().evaluate(extraData);
        Envelope box = polygon.getEnvelopeInternal();
        if (this.properties.containsKey("bbox")) {
            throw new IllegalArgumentException("Filter cannot contain more than one bounding box.");
        }
        this.properties.put("bbox", box.getMinX() + "," + box.getMinY() + "," + box.getMaxX() + "," + box.getMaxY());
        if (!this.properties.containsKey("epsg") && polygon.getSRID() != 0) {
            this.properties.put("epsg", polygon.getSRID() + "");
        }
        return extraData;
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Beyond filter, Object extraData)");
    }

    public Object visit(Contains filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Contains filter, Object extraData)");
    }

    public Object visit(Crosses filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Crosses filter, Object extraData)");
    }

    public Object visit(Disjoint filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Disjoint filter, Object extraData)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(DWithin filter, Object extraData) {
        boolean valid = true;
        if (!(filter.getExpression1() instanceof PropertyName)) {
            valid = false;
        }
        if (!(filter.getExpression2() instanceof Literal)) {
            valid = false;
        }
        if (!valid) {
            throw new UnsupportedOperationException("DWithin filter on this store is supported only if the first operand is the default geometry property and the second is a geometry literal");
        }
        Geometry geometry = (Geometry)filter.getExpression2().evaluate(extraData);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            if (this.properties.containsKey("lon")) {
                throw new IllegalArgumentException("Long. is already set");
            }
            this.properties.put("lon", String.valueOf(point.getX()));
            if (this.properties.containsKey("lat")) throw new IllegalArgumentException("Lat is already set");
            this.properties.put("lat", String.valueOf(point.getY()));
        } else {
            this.writeGeometry(geometry);
        }
        if (this.properties.containsKey("tolerance")) {
            throw new IllegalArgumentException("tolerance is already set");
        }
        this.properties.put("tolerance", String.valueOf(filter.getDistance()));
        if (this.properties.containsKey("epsg")) return extraData;
        this.properties.put("epsg", filter.getDistanceUnits() + "");
        return extraData;
    }

    public Object visit(Equals filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Equals filter, Object extraData)");
    }

    public Object visit(Intersects filter, Object extraData) {
        Geometry goem = (Geometry)filter.getExpression2().evaluate(null);
        this.writeGeometry(goem);
        return extraData;
    }

    private void writeGeometry(Geometry geom) {
        String strGeoJSON;
        if (!this.properties.containsKey("geometry")) {
            strGeoJSON = "";
            GeometryJSON gjson = new GeometryJSON();
            try {
                StringWriter sw = new StringWriter();
                gjson.write(geom, (Object)sw);
                strGeoJSON = sw.toString();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, " Exception at visit  : Intersect Filter " + ex.getMessage(), ex);
            }
        } else {
            throw new IllegalArgumentException("Geometry is already sey");
        }
        this.properties.put("geometry", strGeoJSON);
    }

    public Object visit(Overlaps filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Overlaps filter, Object extraData)");
    }

    public Object visit(Touches filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    public Object visit(Within filter, Object extraData) {
        throw new UnsupportedOperationException("visit (Within filter, Object extraData)");
    }

    public Object visit(After after, Object extraData) {
        throw new UnsupportedOperationException("visit (After filter, Object extraData)");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException("visit (AnyInteracts filter, Object extraData)");
    }

    public Object visit(Before before, Object extraData) {
        throw new UnsupportedOperationException("visit (Before filter, Object extraData)");
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException("visit (Begins filter, Object extraData)");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException("visit (BegunBy filter, Object extraData)");
    }

    public Object visit(During during, Object extraData) {
        throw new UnsupportedOperationException("visit (During filter, Object extraData)");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException("visit (EndedBy filter, Object extraData)");
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException("visit (Ends filter, Object extraData)");
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException("visit (Touches filter, Object extraData)");
    }

    private String getGlueChar() {
        if (!this.hasProperties) {
            this.hasProperties = true;
            return "?";
        }
        return "&";
    }

    private void checkPropertyFilter(String propertyName, String extension, BinaryComparisonOperator filter) {
        Object value;
        String combined = propertyName + extension;
        if (!this.properties.containsKey(combined) && (value = ((Literal)filter.getExpression2()).getValue()) != null) {
            this.properties.put(combined, value.toString());
            if (!this.queryable.contains(propertyName)) {
                this.queryable.add(propertyName);
            }
        }
    }
}

