/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.sfs.SFSDataStore;
import org.geotools.data.sfs.SFSDataStoreUtil;
import org.geotools.data.sfs.SFSFeatureReader;
import org.geotools.data.sfs.SFSLayer;
import org.geotools.data.sfs.SFSQueryCapabilities;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

class SFSFeatureSource
extends ContentFeatureSource
implements SimpleFeatureSource {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.simplefeatureservice");
    Map<String, String> hint = Collections.emptyMap();
    ContentEntry contentEntry;
    SFSDataStore ods;
    SFSLayer layer;

    public SFSFeatureSource(ContentEntry fnEntry) throws IOException {
        super(fnEntry, Query.ALL);
        this.contentEntry = fnEntry;
        this.ods = (SFSDataStore)this.contentEntry.getDataStore();
        this.layer = this.ods.getLayer(this.contentEntry.getName());
    }

    @Override
    public ReferencedEnvelope getBoundsInternal(Query fnQuery) throws IOException {
        JSONArray bbox;
        ReferencedEnvelope env = new ReferencedEnvelope(this.layer.getCoordinateReferenceSystem());
        Filter[] split = this.splitFilter(fnQuery.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        if (postFilter != null && postFilter != Filter.INCLUDE || preFilter == Filter.EXCLUDE) {
            return null;
        }
        Query tmpPreQ = new Query(fnQuery);
        tmpPreQ.setFilter(preFilter);
        String strQuery = SFSDataStoreUtil.encodeQuery(tmpPreQ, this.getSchema());
        String bboxString = this.ods.resourceToString("data/" + this.layer.getTypeName().getLocalPart(), "mode=bounds&" + strQuery);
        try {
            bbox = (JSONArray)new JSONParser().parse(bboxString);
        }
        catch (ParseException e) {
            throw (IOException)new IOException("Failed to parse the bbox JSON array:" + bboxString).initCause(e);
        }
        if (bbox.size() == 4) {
            if (this.layer.isXYOrder()) {
                env.init(((Number)bbox.get(0)).doubleValue(), ((Number)bbox.get(2)).doubleValue(), ((Number)bbox.get(1)).doubleValue(), ((Number)bbox.get(3)).doubleValue());
            } else {
                env.init(((Number)bbox.get(1)).doubleValue(), ((Number)bbox.get(3)).doubleValue(), ((Number)bbox.get(0)).doubleValue(), ((Number)bbox.get(2)).doubleValue());
            }
        } else {
            throw new IOException("The returned bound was not of size 4 but of size: " + bbox.size());
        }
        return env;
    }

    @Override
    protected int getCountInternal(Query fnQuery) throws IOException {
        int count = 0;
        Filter[] split = this.splitFilter(fnQuery.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            return -1;
        }
        Query tmpPreQ = new Query(fnQuery);
        tmpPreQ.setFilter(preFilter);
        String strQuery = SFSDataStoreUtil.encodeQuery(tmpPreQ, this.getSchema());
        String strCount = this.ods.resourceToString("data/" + this.layer.getTypeName().getLocalPart(), "mode=count&" + strQuery);
        try {
            count = Integer.parseInt(strCount);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.SEVERE, "Number format Exception in getCountInternal : FeatureSource -- getCount --" + nfe.getMessage(), nfe);
            return 0;
        }
        if (fnQuery.getStartIndex() != null && fnQuery.getStartIndex() > 0) {
            count = Math.max(0, count - fnQuery.getStartIndex());
        }
        if (fnQuery.getMaxFeatures() > 0 && count > fnQuery.getMaxFeatures()) {
            count = fnQuery.getMaxFeatures();
        }
        return count;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query fnQuery) throws IOException {
        SimpleFeatureType returnedSchema;
        SimpleFeatureType querySchema;
        Filter filter = fnQuery.getFilter();
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        simplifier.setFeatureType((FeatureType)this.getSchema());
        filter = (Filter)filter.accept((FilterVisitor)simplifier, null);
        Filter[] split = this.splitFilter(filter);
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        Query preQuery = new Query(fnQuery);
        preQuery.setFilter(preFilter);
        if (fnQuery.getPropertyNames() == Query.ALL_NAMES) {
            returnedSchema = querySchema = this.getSchema();
        } else {
            returnedSchema = SimpleFeatureTypeBuilder.retype(this.getSchema(), fnQuery.getPropertyNames());
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(this.getSchema());
            filter.accept((FilterVisitor)extractor, null);
            String[] extraAttributes = extractor.getAttributeNames();
            if (extraAttributes == null || extraAttributes.length == 0) {
                querySchema = returnedSchema;
            } else {
                ArrayList<String> allAttributes = new ArrayList<String>(Arrays.asList(fnQuery.getPropertyNames()));
                for (String extraAttribute : extraAttributes) {
                    if (allAttributes.contains(extraAttribute)) continue;
                    allAttributes.add(extraAttribute);
                }
                String[] allAttributeArray = allAttributes.toArray(new String[allAttributes.size()]);
                preQuery.setPropertyNames(allAttributeArray);
                querySchema = SimpleFeatureTypeBuilder.retype(this.getSchema(), allAttributeArray);
            }
        }
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = new SFSFeatureReader(this.getState(), this.layer, preQuery, querySchema);
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, filter);
        }
        if (querySchema.getAttributeCount() > returnedSchema.getAttributeCount()) {
            reader = new ReTypeFeatureReader(reader, returnedSchema);
        }
        return reader;
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException, MalformedURLException {
        String jsonString = this.ods.resourceToString("describe/" + this.contentEntry.getName().getLocalPart(), null);
        JSONParser parser = new JSONParser();
        JSONArray jsonArray = null;
        try {
            jsonArray = (JSONArray)parser.parse(jsonString);
        }
        catch (ParseException pe) {
            LOGGER.log(Level.SEVERE, "parse Exception : FeatureSource -- buildFeatureType --" + pe.getMessage(), pe);
        }
        SimpleFeatureTypeBuilder fbt = new SimpleFeatureTypeBuilder();
        fbt.setName(this.contentEntry.getName());
        fbt.setCRS(this.layer.getCoordinateReferenceSystem());
        for (HashMap tmpMap : jsonArray) {
            for (Map.Entry entry : tmpMap.entrySet()) {
                fbt.add((String)entry.getKey(), SFSDataStoreUtil.getClass((String)entry.getValue()));
            }
        }
        return fbt.buildFeatureType();
    }

    public QueryCapabilities getQueryCapabilities(SimpleFeatureType fnSchema) throws IOException {
        SFSQueryCapabilities odsc = new SFSQueryCapabilities(fnSchema);
        return odsc;
    }

    public SimpleFeature getFeatureWithID(String fnID) throws MalformedURLException, IOException, ParseException {
        if (fnID == null) {
            throw new IOException("FeatureID cannot be null");
        }
        String jsonString = this.ods.resourceToString("data/" + this.contentEntry.getName().getLocalPart() + "/" + fnID, null);
        FeatureJSON fjson = new FeatureJSON();
        SimpleFeature feature = fjson.readFeature((Object)new StringReader(SFSDataStoreUtil.strip(jsonString)));
        return feature;
    }

    Filter[] splitFilter(Filter fnOriginalFilter) {
        Filter[] split = new Filter[2];
        if (fnOriginalFilter != null) {
            PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(SFSDataStore.ODS_FILTER_CAPABILITIES, this.getSchema(), null);
            fnOriginalFilter.accept((FilterVisitor)splitter, null);
            split[0] = splitter.getFilterPre();
            split[1] = splitter.getFilterPost();
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setFeatureType((FeatureType)this.getSchema());
        split[0] = (Filter)split[0].accept((FilterVisitor)visitor, null);
        split[1] = (Filter)split[1].accept((FilterVisitor)visitor, null);
        return split;
    }

    @Override
    protected boolean canFilter() {
        return true;
    }

    @Override
    protected boolean canLimit() {
        return true;
    }

    @Override
    protected boolean canOffset() {
        return true;
    }

    @Override
    protected boolean canRetype() {
        return true;
    }

    @Override
    protected boolean canSort() {
        return true;
    }
}

