/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.geotools.data.sfs.SFSDataStoreUtil;
import org.geotools.data.sfs.SFSFeatureSource;
import org.geotools.data.sfs.SFSLayer;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FilterCapabilities;
import org.geotools.util.logging.Logging;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SFSDataStore
extends ContentDataStore {
    static FilterCapabilities ODS_FILTER_CAPABILITIES = new FilterCapabilities(){
        {
            this.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
            this.addType(And.class);
            this.addType(BBOX.class);
            this.addType(Intersects.class);
            this.addType(IncludeFilter.class);
            this.addType(ExcludeFilter.class);
            this.addType(PropertyIsLike.class);
        }
    };
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.simplefeatureservice");
    String baseURL;
    Map<Name, SFSLayer> layers = new LinkedHashMap<Name, SFSLayer>();
    String user;
    String password;
    int timeout;

    public SFSDataStore(URL fnURL, String namespaceURI) throws IOException {
        String strURL = fnURL.toString();
        this.baseURL = strURL + (strURL.endsWith("/") ? "" : "/");
        if (this.baseURL.endsWith("capabilities/")) {
            this.baseURL = this.baseURL.substring(0, this.baseURL.length() - "capabilities/".length());
        }
        this.namespaceURI = namespaceURI;
        this.processCapabilities();
    }

    public SFSDataStore(URL fnURL, String namespaceURI, String user, String password, int timeout) throws IOException {
        String strURL = fnURL.toString();
        this.baseURL = strURL + (strURL.endsWith("/") ? "" : "/");
        if (this.baseURL.endsWith("capabilities/")) {
            this.baseURL = this.baseURL.substring(0, this.baseURL.length() - "capabilities/".length());
        }
        this.namespaceURI = namespaceURI;
        this.user = user;
        this.password = password;
        this.timeout = timeout;
        this.processCapabilities();
    }

    SFSDataStore(String json, String namespaceURI) throws IOException {
        this.namespaceURI = namespaceURI;
        this.processCapabilities(json);
    }

    public final void processCapabilities() throws IOException {
        this.processCapabilities(this.resourceToString("capabilities", null));
    }

    final void processCapabilities(String capabilitiesJSON) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(capabilitiesJSON);
            JSONArray array = (JSONArray)obj;
            for (HashMap tmpMap : array) {
                String strName = ((String)tmpMap.get("name")).trim();
                NameImpl name = new NameImpl(this.namespaceURI, strName);
                boolean xyOrder = !tmpMap.containsKey("axisorder") ? true : tmpMap.get("axisorder").equals("xy");
                String strCRS = null;
                CoordinateReferenceSystem crs = null;
                if (tmpMap.containsKey("crs")) {
                    strCRS = ((String)tmpMap.get("crs")).trim();
                    crs = SFSDataStoreUtil.decodeXY(strCRS);
                }
                Envelope envelope = null;
                if (tmpMap.containsKey("bbox")) {
                    JSONArray boundingArray = (JSONArray)tmpMap.get("bbox");
                    if (!xyOrder) {
                        SFSDataStoreUtil.flipYXInsideTheBoundingBox((ArrayList)boundingArray);
                    }
                    envelope = new Envelope(((Number)boundingArray.get(0)).doubleValue(), ((Number)boundingArray.get(2)).doubleValue(), ((Number)boundingArray.get(1)).doubleValue(), ((Number)boundingArray.get(3)).doubleValue());
                }
                SFSLayer layer = new SFSLayer(name, xyOrder, strCRS, crs, envelope);
                this.layers.put(name, layer);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception occurred while parsing the capabilities", e);
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public List<Name> createTypeNames() throws IOException {
        return new ArrayList<Name>(this.layers.keySet());
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        return new SFSFeatureSource(entry);
    }

    SFSLayer getLayer(Name name) {
        return this.layers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String resourceToString(String resource, String postData) throws IOException {
        InputStream is = this.resourceToStream(resource, postData);
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream resourceToStream(String resource, String postData) throws MalformedURLException, IOException, ProtocolException {
        boolean doPost = false;
        URL url = postData != null && this.baseURL.length() + resource.length() + postData.length() < 2048 ? new URL(this.baseURL + resource + "?" + postData) : new URL(this.baseURL + resource);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestProperty("Accept-Encoding", "gzip");
        if (this.user != null && this.password != null) {
            String combined = this.nullToEmpty(this.user) + ":" + this.nullToEmpty(this.password);
            byte[] authBytes = combined.getBytes("US-ASCII");
            String encoded = new String(Base64.encodeBase64((byte[])authBytes));
            urlConnection.setRequestProperty("Authorization", "Basic " + encoded);
        }
        if (this.timeout > 0) {
            urlConnection.setConnectTimeout(this.timeout);
            urlConnection.setReadTimeout(this.timeout);
        }
        urlConnection.setDoInput(true);
        if (doPost && postData != null && !"".equals(postData.trim())) {
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setDoOutput(true);
            try (OutputStreamWriter wr = null;){
                wr = new OutputStreamWriter(urlConnection.getOutputStream());
                wr.write(postData);
                wr.flush();
            }
        } else {
            urlConnection.setRequestMethod("GET");
        }
        if (urlConnection.getResponseCode() != 200) {
            throw new IOException("Server reported and error with code " + urlConnection.getResponseCode() + ": " + urlConnection.getResponseMessage() + " accessing resource " + url.toExternalForm());
        }
        InputStream is = urlConnection.getInputStream();
        String encoding = urlConnection.getContentEncoding();
        if ("gzip".equalsIgnoreCase(encoding)) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    private String nullToEmpty(String string) {
        return string != null ? string : "";
    }
}

