/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.utils;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.map.Layer;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swt.control.ExceptionMonitor;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ContrastMethod;
import org.opengis.style.Fill;
import org.opengis.style.SelectedChannelType;

public class Utils {
    public static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    public static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    public static StyleBuilder sb = new StyleBuilder(styleFactory, filterFactory);
    private static final Class<?> BASE_GRID_CLASS = GridCoverage.class;
    private static final Class<?> BASE_READER_CLASS = GridCoverageReader.class;

    public static void setShellLocation(Shell shell) {
        org.eclipse.swt.graphics.Rectangle monitorArea = shell.getDisplay().getPrimaryMonitor().getBounds();
        org.eclipse.swt.graphics.Rectangle shellArea = shell.getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        shell.setLocation(x, y);
    }

    public static org.eclipse.swt.graphics.Rectangle toSwtRectangle(Rectangle rect2d) {
        return new org.eclipse.swt.graphics.Rectangle((int)Math.round(rect2d.getMinX()), (int)Math.round(rect2d.getMinY()), (int)Math.round(rect2d.getWidth()), (int)Math.round(rect2d.getHeight()));
    }

    public static Rectangle toAwtRectangle(org.eclipse.swt.graphics.Rectangle rect) {
        Rectangle rect2d = new Rectangle();
        rect2d.setRect(rect.x, rect.y, rect.width, rect.height);
        return rect2d;
    }

    public static Style createStyle(File file, SimpleFeatureSource featureSource) {
        File sld = Utils.toSLDFile(file);
        if (sld != null) {
            return Utils.createFromSLD(sld);
        }
        return Utils.createStyle2(featureSource);
    }

    public static File toSLDFile(File file) {
        String path = file.getAbsolutePath();
        String base = path.substring(0, path.length() - 4);
        String newPath = base + ".sld";
        File sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        newPath = base + ".SLD";
        sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        return null;
    }

    public static Style createFromSLD(File sld) {
        try {
            SLDParser stylereader = new SLDParser(styleFactory, sld.toURI().toURL());
            Style[] style = stylereader.readXML();
            return style[0];
        }
        catch (Exception e) {
            ExceptionMonitor.show(null, e, "Problem creating style");
            return null;
        }
    }

    public static Style createStyle2(SimpleFeatureSource featureSource) {
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        Class geomType = schema.getGeometryDescriptor().getType().getBinding();
        if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            return Utils.createPolygonStyle();
        }
        if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
            return Utils.createLineStyle();
        }
        return Utils.createPointStyle();
    }

    public static Style createPolygonStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1), (Expression)filterFactory.literal(0.5));
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN), (Expression)filterFactory.literal(0.5));
        PolygonSymbolizer sym = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    public static Style createLineStyle() {
        Stroke stroke = styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1));
        LineSymbolizer sym = styleFactory.createLineSymbolizer(stroke, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    public static Style createPointStyle() {
        Graphic gr = styleFactory.createDefaultGraphic();
        Mark mark = styleFactory.getCircleMark();
        mark.setStroke((org.opengis.style.Stroke)styleFactory.createStroke((Expression)filterFactory.literal((Object)Color.BLUE), (Expression)filterFactory.literal(1)));
        mark.setFill((Fill)styleFactory.createFill((Expression)filterFactory.literal((Object)Color.CYAN)));
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(mark);
        gr.setSize((Expression)filterFactory.literal(5));
        PointSymbolizer sym = styleFactory.createPointSymbolizer(gr, null);
        Rule rule = styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    public static void runGuiRunnableSafe(Runnable runner, boolean sync) {
        if (Display.getCurrent() != null) {
            runner.run();
        } else if (sync) {
            Display.getDefault().syncExec(runner);
        } else {
            Display.getDefault().asyncExec(runner);
        }
    }

    public static Style createRGBStyle(GridCoverage2DReader reader) {
        GridCoverage2D cov = null;
        try {
            cov = reader.read(null);
        }
        catch (IOException giveUp) {
            throw new RuntimeException(giveUp);
        }
        int numBands = cov.getNumSampleDimensions();
        if (numBands < 3) {
            return null;
        }
        String[] sampleDimensionNames = new String[numBands];
        for (int i = 0; i < numBands; ++i) {
            GridSampleDimension dim = cov.getSampleDimension(i);
            sampleDimensionNames[i] = dim.getDescription().toString();
        }
        boolean RED = false;
        boolean GREEN = true;
        int BLUE = 2;
        int[] channelNum = new int[]{-1, -1, -1};
        for (int i = 0; i < numBands; ++i) {
            String name = sampleDimensionNames[i].toLowerCase();
            if (name == null) continue;
            if (name.matches("red.*")) {
                channelNum[0] = i + 1;
                continue;
            }
            if (name.matches("green.*")) {
                channelNum[1] = i + 1;
                continue;
            }
            if (!name.matches("blue.*")) continue;
            channelNum[2] = i + 1;
        }
        if (channelNum[0] < 0 || channelNum[1] < 0 || channelNum[2] < 0) {
            channelNum[0] = 1;
            channelNum[1] = 2;
            channelNum[2] = 3;
        }
        org.geotools.styling.SelectedChannelType[] sct = new org.geotools.styling.SelectedChannelType[cov.getNumSampleDimensions()];
        ContrastEnhancement ce = styleFactory.contrastEnhancement((Expression)filterFactory.literal(1.0), ContrastMethod.NORMALIZE);
        for (int i = 0; i < 3; ++i) {
            sct[i] = styleFactory.createSelectedChannelType(String.valueOf(channelNum[i]), ce);
        }
        RasterSymbolizer sym = styleFactory.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = styleFactory.channelSelection((SelectedChannelType)sct[0], (SelectedChannelType)sct[1], (SelectedChannelType)sct[2]);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers(new Symbolizer[]{sym});
    }

    public static boolean isGridLayer(Layer layer) {
        Collection descriptors = layer.getFeatureSource().getSchema().getDescriptors();
        for (PropertyDescriptor desc : descriptors) {
            Class binding = desc.getType().getBinding();
            if (!BASE_GRID_CLASS.isAssignableFrom(binding) && !BASE_READER_CLASS.isAssignableFrom(binding)) continue;
            return true;
        }
        return false;
    }

    public static String getGridAttributeName(Layer layer) {
        String attrName = null;
        Collection descriptors = layer.getFeatureSource().getSchema().getDescriptors();
        for (PropertyDescriptor desc : descriptors) {
            Class binding = desc.getType().getBinding();
            if (!BASE_GRID_CLASS.isAssignableFrom(binding) && !BASE_READER_CLASS.isAssignableFrom(binding)) continue;
            attrName = desc.getName().getLocalPart();
            break;
        }
        return attrName;
    }
}

