/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.utils;

import org.eclipse.jface.window.ApplicationWindow;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.event.MapMouseAdapter;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.event.MapPaneAdapter;
import org.geotools.swt.event.MapPaneEvent;

public class StatusBarNotifier {
    private final ApplicationWindow applicationWindow;
    private MapMouseAdapter mouseListener;
    private MapPaneAdapter mapPaneListener;

    public StatusBarNotifier(ApplicationWindow applicationWindow, SwtMapPane mapPane) {
        this.applicationWindow = applicationWindow;
        this.createListeners();
        mapPane.addMouseListener(this.mouseListener);
        mapPane.addMapPaneListener(this.mapPaneListener);
    }

    private void createListeners() {
        this.mouseListener = new MapMouseAdapter(){

            @Override
            public void onMouseMoved(MapMouseEvent ev) {
                StatusBarNotifier.this.displayCoords(ev.getMapPosition());
            }

            @Override
            public void onMouseExited(MapMouseEvent ev) {
                StatusBarNotifier.this.clearCoords();
            }
        };
        this.mapPaneListener = new MapPaneAdapter(){

            @Override
            public void onDisplayAreaChanged(MapPaneEvent ev) {
            }

            @Override
            public void onResized(MapPaneEvent ev) {
            }

            @Override
            public void onRenderingStarted(MapPaneEvent ev) {
                StatusBarNotifier.this.applicationWindow.setStatus("rendering...");
            }

            @Override
            public void onRenderingStopped(MapPaneEvent ev) {
                StatusBarNotifier.this.applicationWindow.setStatus("");
            }

            @Override
            public void onRenderingProgress(MapPaneEvent ev) {
            }
        };
    }

    public void displayCoords(DirectPosition2D mapPos) {
        if (mapPos != null) {
            this.applicationWindow.setStatus(String.format("  %.2f %.2f", mapPos.x, mapPos.y));
        }
    }

    public void clearCoords() {
        this.applicationWindow.setStatus("");
    }
}

