/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    public static final String CHECKED = "/icons/checked.gif";
    public static final String UNCHECKED = "/icons/unchecked.gif";
    public static final String STYLE = "/icons/style.gif";
    public static final String GRID = "/icons/grid.gif";
    public static final String FEATURE = "/icons/feature.gif";
    public static final String UP = "/icons/up.gif";
    public static final String DOWN = "/icons/down.gif";
    public static final String OPEN = "/icons/open.gif";
    public static final String ALPHA = "/icons/alpha.gif";
    public static final String REMOVE_LAYER = "/icons/remove_layer.gif";
    public static final String IMAGE_INFO = "/icons/info_mode.gif";
    public static final String IMAGE_INFO_ICON = "/icons/info_source.gif";
    public static final String IMAGE_PAN = "/icons/pan_mode.gif";
    public static final String IMAGE_ZOOMIN = "/icons/zoom_in_co.gif";
    public static final String IMAGE_ZOOMOUT = "/icons/zoom_out_co.gif";
    public static final String IMAGE_FULLEXTENT = "/icons/zoom_extent_co.gif";
    private static ImageCache imageCache;
    private HashMap<String, Image> imageMap = new HashMap();

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (imageCache == null) {
            imageCache = new ImageCache();
        }
        return imageCache;
    }

    public Image getImage(String key) {
        Image image = this.imageMap.get(key);
        if (image == null) {
            image = this.createImage(key);
            this.imageMap.put(key, image);
        }
        return image;
    }

    private Image createImage(String key) {
        Image image = null;
        try {
            int len;
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File temporaryFile = new File(tempDir, key);
            temporaryFile.getParentFile().mkdirs();
            InputStream in = this.getClass().getResourceAsStream(key);
            FileOutputStream out = new FileOutputStream(temporaryFile);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            image = new Image((Device)Display.getCurrent(), temporaryFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public void dispose() {
        Set<Map.Entry<String, Image>> entrySet = this.imageMap.entrySet();
        for (Map.Entry<String, Image> entry : entrySet) {
            entry.getValue().dispose();
        }
        this.imageMap.clear();
    }

    public void addImage(String key, Image image) {
        this.imageMap.put(key, image);
    }

    public List<String> getRelativePaths() {
        return Arrays.asList(CHECKED, UNCHECKED, STYLE, GRID, FEATURE, UP, DOWN, OPEN, REMOVE_LAYER, IMAGE_INFO, IMAGE_INFO_ICON, IMAGE_PAN, IMAGE_ZOOMIN, IMAGE_ZOOMOUT, IMAGE_FULLEXTENT);
    }
}

