/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.utils;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.geotools.swt.utils.ImageCache;

public class CursorManager {
    public static final Point CURSOR_HOTSPOT_INFO = new Point(4, 4);
    public static final Point CURSOR_HOTSPOT_PAN = new Point(8, 8);
    public static final Point CURSOR_HOTSPOT_ZOOMIN = new Point(6, 6);
    public static final Point CURSOR_HOTSPOT_ZOOMOUT = new Point(6, 6);
    private Cursor currentCursor = null;
    private static CursorManager instance = null;

    private CursorManager() {
    }

    public static CursorManager getInstance() {
        if (instance == null) {
            instance = new CursorManager();
        }
        return instance;
    }

    public Cursor getArrowCursor() {
        if (this.currentCursor != null && !this.currentCursor.isDisposed()) {
            this.currentCursor.dispose();
        }
        this.currentCursor = new Cursor((Device)Display.getCurrent(), 0);
        return this.currentCursor;
    }

    public Cursor getInfoCursor() {
        Image image = ImageCache.getInstance().getImage("/icons/info_source.gif");
        this.setCursor(image, CURSOR_HOTSPOT_INFO);
        return this.currentCursor;
    }

    public Cursor getPanCursor() {
        Image image = ImageCache.getInstance().getImage("/icons/pan_mode.gif");
        this.setCursor(image, CURSOR_HOTSPOT_PAN);
        return this.currentCursor;
    }

    public Cursor getZoominCursor() {
        Image image = ImageCache.getInstance().getImage("/icons/zoom_in_co.gif");
        this.setCursor(image, CURSOR_HOTSPOT_ZOOMIN);
        return this.currentCursor;
    }

    public Cursor getZoomoutCursor() {
        Image image = ImageCache.getInstance().getImage("/icons/zoom_out_co.gif");
        this.setCursor(image, CURSOR_HOTSPOT_ZOOMOUT);
        return this.currentCursor;
    }

    public void setCursor(Image image, Point hotspot) {
        if (this.currentCursor != null && !this.currentCursor.isDisposed()) {
            this.currentCursor.dispose();
        }
        Display display = Display.getCurrent();
        this.currentCursor = new Cursor((Device)display, image.getImageData(), hotspot.x, hotspot.y);
    }
}

