/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.utils;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.control.CRSChooserDialog;
import org.geotools.swt.event.MapPaneAdapter;
import org.geotools.swt.event.MapPaneEvent;
import org.geotools.swt.utils.Messages;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CrsStatusBarButton
extends ControlContribution
implements MapBoundsListener {
    public static final String ID = "eu.hydrologis.toolbar.toponimicombo";
    private final SwtMapPane mapPane;
    private Button crsButton;
    private MapPaneAdapter mapPaneListener;

    public CrsStatusBarButton(SwtMapPane mapPane) {
        this(ID, mapPane);
    }

    protected CrsStatusBarButton(String id, SwtMapPane mapPane) {
        super(id);
        this.mapPane = mapPane;
    }

    protected Control createControl(Composite parent) {
        this.createListeners();
        this.mapPane.addMapPaneListener(this.mapPaneListener);
        this.mapPane.getMapContent().addMapBoundsListener(this);
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        mainComposite.setLayout((Layout)gridLayout);
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        mainComposite.setLayoutData((Object)statusLineLayoutData);
        this.crsButton = new Button(mainComposite, 8);
        GridData crsButtonGD = new GridData(1, 0x1000000, false, false);
        crsButtonGD.widthHint = 300;
        this.crsButton.setLayoutData((Object)crsButtonGD);
        CoordinateReferenceSystem crs = this.getCrs();
        this.displayCRS(crs);
        this.crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CRSChooserDialog dialog = new CRSChooserDialog(CrsStatusBarButton.this.crsButton.getShell(), CrsStatusBarButton.this.getCrs());
                dialog.setBlockOnOpen(true);
                dialog.open();
                CoordinateReferenceSystem newCrs = dialog.getResult();
                CrsStatusBarButton.this.mapPane.setCrs(newCrs);
                CrsStatusBarButton.this.mapPane.redraw();
                CrsStatusBarButton.this.displayCRS(newCrs);
            }
        });
        return mainComposite;
    }

    private CoordinateReferenceSystem getCrs() {
        return this.mapPane.getMapContent().getCoordinateReferenceSystem();
    }

    private void displayCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            this.crsButton.setText(Messages.getString("crs_undefined"));
        } else {
            this.crsButton.setText(crs.getName().toString());
        }
    }

    private void createListeners() {
        this.mapPaneListener = new MapPaneAdapter(){

            @Override
            public void onDisplayAreaChanged(MapPaneEvent ev) {
                ReferencedEnvelope env = CrsStatusBarButton.this.mapPane.getDisplayArea();
                if (env != null) {
                    CrsStatusBarButton.this.displayCRS(env.getCoordinateReferenceSystem());
                }
            }

            @Override
            public void onResized(MapPaneEvent ev) {
                ReferencedEnvelope env = CrsStatusBarButton.this.mapPane.getDisplayArea();
                if (env != null) {
                    CrsStatusBarButton.this.displayCRS(env.getCoordinateReferenceSystem());
                }
            }

            @Override
            public void onRenderingStarted(MapPaneEvent ev) {
            }

            @Override
            public void onRenderingStopped(MapPaneEvent ev) {
            }

            @Override
            public void onRenderingProgress(MapPaneEvent ev) {
            }
        };
    }

    @Override
    public void mapBoundsChanged(MapBoundsEvent event) {
        ReferencedEnvelope env = this.mapPane.getDisplayArea();
        if (env != null) {
            this.displayCRS(env.getCoordinateReferenceSystem());
        }
    }
}

