/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import java.awt.geom.Point2D;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.tool.AbstractZoomTool;
import org.geotools.swt.tool.CursorTool;
import org.geotools.swt.utils.CursorManager;
import org.geotools.swt.utils.Messages;
import org.opengis.geometry.Envelope;

public class ZoomOutTool
extends AbstractZoomTool {
    public static final String TOOL_NAME = Messages.getString("tool_name_zoom_out");
    public static final String TOOL_TIP = Messages.getString("tool_tip_zoom_out");
    private Cursor cursor = CursorManager.getInstance().getZoomoutCursor();

    public ZoomOutTool(int triggerButtonMask) {
        super(triggerButtonMask);
    }

    public ZoomOutTool() {
        this(CursorTool.ANY_BUTTON);
    }

    @Override
    public void onMouseClicked(MapMouseEvent ev) {
        if (!this.isTriggerMouseButton(ev)) {
            return;
        }
        Rectangle paneArea = this.getMapPane().getBounds();
        DirectPosition2D mapPos = ev.getMapPosition();
        double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
        double newScale = scale / this.zoom;
        DirectPosition2D corner = new DirectPosition2D(mapPos.getX() - 0.5 * (double)paneArea.width / newScale, mapPos.getY() + 0.5 * (double)paneArea.height / newScale);
        Envelope2D newMapArea = new Envelope2D();
        newMapArea.setFrameFromCenter((Point2D)mapPos, (Point2D)corner);
        this.getMapPane().setDisplayArea((Envelope)newMapArea);
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean canDraw() {
        return false;
    }

    @Override
    public boolean canMove() {
        return false;
    }
}

