/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import java.awt.geom.Point2D;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.tool.AbstractZoomTool;
import org.geotools.swt.tool.CursorTool;
import org.geotools.swt.utils.CursorManager;
import org.geotools.swt.utils.Messages;
import org.opengis.geometry.Envelope;

public class ZoomInTool
extends AbstractZoomTool {
    public static final String TOOL_NAME = Messages.getString("tool_name_zoom_in");
    public static final String TOOL_TIP = Messages.getString("tool_tip_zoom_in");
    private Cursor cursor = CursorManager.getInstance().getZoominCursor();
    private Point2D startDragPos = new DirectPosition2D();
    private boolean dragged = false;

    public ZoomInTool(int triggerButtonMask) {
        super(triggerButtonMask);
    }

    public ZoomInTool() {
        this(CursorTool.ANY_BUTTON);
    }

    @Override
    public void onMouseClicked(MapMouseEvent e) {
        if (!this.isTriggerMouseButton(e)) {
            return;
        }
        this.startDragPos = new DirectPosition2D();
        this.startDragPos.setLocation((Point2D)e.getMapPosition());
    }

    @Override
    public void onMousePressed(MapMouseEvent ev) {
    }

    @Override
    public void onMouseDragged(MapMouseEvent ev) {
        if (!this.isTriggerMouseButton(ev)) {
            return;
        }
        this.dragged = true;
    }

    @Override
    public void onMouseReleased(MapMouseEvent ev) {
        if (!this.isTriggerMouseButton(ev)) {
            return;
        }
        if (this.dragged) {
            Envelope2D env = new Envelope2D();
            env.setFrameFromDiagonal(this.startDragPos, (Point2D)ev.getMapPosition());
            this.dragged = false;
            this.getMapPane().setDisplayArea((Envelope)env);
        } else {
            Rectangle paneArea = this.getMapPane().getVisibleRect();
            double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
            double newScale = scale * this.zoom;
            DirectPosition2D corner = new DirectPosition2D(this.startDragPos.getX() - 0.5 * (double)paneArea.width / newScale, this.startDragPos.getY() + 0.5 * (double)paneArea.height / newScale);
            Envelope2D newMapArea = new Envelope2D();
            newMapArea.setFrameFromCenter(this.startDragPos, (Point2D)corner);
            this.getMapPane().setDisplayArea((Envelope)newMapArea);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean canDraw() {
        return true;
    }

    @Override
    public boolean canMove() {
        return false;
    }

    @Override
    public boolean isDrawing() {
        return this.dragged;
    }

    public static double pythagoras(double d1, double d2) {
        return Math.sqrt(Math.pow(d1, 2.0) + Math.pow(d2, 2.0));
    }
}

