/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.swt.tool.InfoToolHelper;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class VectorLayerHelper
extends InfoToolHelper<SimpleFeatureCollection> {
    private static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    private static final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private final WeakReference<Layer> layerRef;
    private final String attrName;
    private final boolean isPolygonGeometry;

    public VectorLayerHelper(MapContent context, Layer layer) {
        super(context, layer.getFeatureSource().getSchema().getCoordinateReferenceSystem());
        this.layerRef = new WeakReference<Layer>(layer);
        GeometryDescriptor geomDesc = layer.getFeatureSource().getSchema().getGeometryDescriptor();
        this.attrName = geomDesc.getLocalName();
        Class geomClass = geomDesc.getType().getBinding();
        Geometries type = Geometries.getForBinding((Class)geomClass);
        this.isPolygonGeometry = type == Geometries.POLYGON || type == Geometries.MULTIPOLYGON;
    }

    @Override
    public boolean isValid() {
        return this.getMapContent() != null && this.layerRef != null && this.layerRef.get() != null;
    }

    public Layer getMapLayer() {
        return this.layerRef != null ? (Layer)this.layerRef.get() : null;
    }

    @Override
    public SimpleFeatureCollection getInfo(DirectPosition2D pos, Object ... params) throws IOException {
        SimpleFeatureCollection collection = null;
        Layer layer = (Layer)this.layerRef.get();
        if (layer != null) {
            Intersects filter = null;
            if (this.isPolygonGeometry) {
                Geometry posGeom = this.createSearchPos(pos);
                filter = filterFactory.intersects((Expression)filterFactory.property(this.attrName), (Expression)filterFactory.literal((Object)posGeom));
            } else {
                double radius = ((Number)params[0]).doubleValue();
                ReferencedEnvelope env = this.createSearchEnv(pos, radius);
                filter = filterFactory.bbox((Expression)filterFactory.property(this.attrName), (BoundingBox)env);
            }
            Query query = new Query(null, (Filter)filter);
            query.setCoordinateSystemReproject(this.getMapContent().getCoordinateReferenceSystem());
            collection = (SimpleFeatureCollection)layer.getFeatureSource().getFeatures(query);
        }
        return collection;
    }

    private Geometry createSearchPos(DirectPosition2D pos) {
        MathTransform transform;
        Point point = geometryFactory.createPoint(new Coordinate(pos.x, pos.y));
        if (this.isTransformRequired() && (transform = this.getTransform()) != null) {
            try {
                point = JTS.transform((Geometry)point, (MathTransform)transform);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return point;
    }

    private ReferencedEnvelope createSearchEnv(DirectPosition2D pos, double radius) {
        CoordinateReferenceSystem contextCRS = this.getMapContent().getCoordinateReferenceSystem();
        ReferencedEnvelope env = new ReferencedEnvelope(pos.x - radius, pos.x + radius, pos.y - radius, pos.y + radius, contextCRS);
        if (this.isTransformRequired()) {
            CoordinateReferenceSystem layerCRS = ((Layer)this.layerRef.get()).getFeatureSource().getSchema().getCoordinateReferenceSystem();
            try {
                env = env.transform(layerCRS, true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return env;
    }
}

