/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.tool.CursorTool;
import org.geotools.swt.utils.CursorManager;
import org.geotools.swt.utils.Messages;

public class PanTool
extends CursorTool {
    public static final String TOOL_NAME = Messages.getString("tool_name_pan");
    public static final String TOOL_TIP = Messages.getString("tool_tip_pan");
    private Cursor cursor = CursorManager.getInstance().getPanCursor();
    private Point panePos;
    boolean panning = false;

    public PanTool(int triggerButtonMask) {
        super(triggerButtonMask);
    }

    public PanTool() {
        this(CursorTool.ANY_BUTTON);
    }

    @Override
    public void onMousePressed(MapMouseEvent ev) {
        if (!this.isTriggerMouseButton(ev)) {
            return;
        }
        this.panePos = ev.getPoint();
        this.panning = true;
    }

    @Override
    public void onMouseDragged(MapMouseEvent ev) {
        Point pos;
        if (this.panning && !(pos = ev.getPoint()).equals((Object)this.panePos)) {
            this.getMapPane().moveImage(pos.x - this.panePos.x, pos.y - this.panePos.y);
            this.panePos = pos;
        }
    }

    @Override
    public void onMouseReleased(MapMouseEvent ev) {
        if (this.panning) {
            this.panning = false;
            this.getMapPane().redraw();
        }
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean canDraw() {
        return false;
    }

    @Override
    public boolean canMove() {
        return true;
    }
}

