/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.event.MapMouseListener;
import org.geotools.swt.tool.CursorTool;
import org.geotools.swt.utils.Messages;

public class MapToolManager
implements MouseListener,
MouseMoveListener,
MouseWheelListener,
MouseTrackListener {
    private SwtMapPane mapPane;
    private Set<MapMouseListener> listeners = new HashSet<MapMouseListener>();
    private CursorTool cursorTool;
    boolean isMouseDown = false;

    public MapToolManager(SwtMapPane pane) {
        this.mapPane = pane;
    }

    public void setNoCursorTool() {
        this.listeners.remove(this.cursorTool);
        this.cursorTool = null;
    }

    public boolean setCursorTool(CursorTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        if (this.cursorTool != null) {
            this.listeners.remove(this.cursorTool);
        }
        this.cursorTool = tool;
        this.cursorTool.setMapPane(this.mapPane);
        return this.listeners.add(tool);
    }

    public CursorTool getCursorTool() {
        return this.cursorTool;
    }

    public boolean addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        return this.listeners.add(listener);
    }

    public boolean removeMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        return this.listeners.remove(listener);
    }

    public void mouseScrolled(MouseEvent e) {
        MapMouseEvent ev = this.convertWheelEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseWheelMoved(ev);
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                if (this.isMouseDown) {
                    listener.onMouseDragged(ev);
                    continue;
                }
                listener.onMouseMoved(ev);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent e) {
        this.isMouseDown = true;
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseClicked(ev);
            }
            for (MapMouseListener listener : this.listeners) {
                listener.onMousePressed(ev);
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        this.isMouseDown = false;
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseReleased(ev);
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseEntered(ev);
            }
        }
    }

    public void mouseExit(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseExited(ev);
            }
        }
    }

    public void mouseHover(MouseEvent arg0) {
    }

    private MapMouseEvent convertEvent(MouseEvent e) {
        MapMouseEvent ev = null;
        if (this.mapPane.getScreenToWorldTransform() != null) {
            ev = new MapMouseEvent(this.mapPane, e, false);
        }
        return ev;
    }

    private MapMouseEvent convertWheelEvent(MouseEvent e) {
        MapMouseEvent ev = null;
        if (this.mapPane.getScreenToWorldTransform() != null) {
            ev = new MapMouseEvent(this.mapPane, e, true);
        }
        return ev;
    }
}

