/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.swt.control.JTextReporter;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.tool.CursorTool;
import org.geotools.swt.tool.InfoToolHelper;
import org.geotools.swt.tool.VectorLayerHelper;
import org.geotools.swt.utils.CursorManager;
import org.geotools.swt.utils.Messages;
import org.geotools.swt.utils.Utils;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;

public class InfoTool
extends CursorTool {
    public static final String TOOL_NAME = Messages.getString("tool_name_info");
    public static final String TOOL_TIP = Messages.getString("tool_tip_info");
    public static final double DEFAULT_DISTANCE_FRACTION = 0.01;
    private Cursor cursor = CursorManager.getInstance().getInfoCursor();
    private JTextReporter reporter;
    private WeakHashMap<Layer, InfoToolHelper<?>> helperTable = new WeakHashMap();

    public InfoTool(int triggerButtonMask) {
        super(triggerButtonMask);
    }

    public InfoTool() {
        this(CursorTool.ANY_BUTTON);
    }

    @Override
    public void onMouseClicked(MapMouseEvent ev) {
        if (!this.isTriggerMouseButton(ev)) {
            return;
        }
        DirectPosition2D pos = ev.getMapPosition();
        this.report(pos);
        MapContent context = this.getMapPane().getMapContent();
        for (Layer layer : context.layers()) {
            List bandValues;
            if (!layer.isSelected()) continue;
            InfoToolHelper helper = null;
            String layerName = layer.getTitle();
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getName().getLocalPart();
            }
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getSchema().getName().getLocalPart();
            }
            if ((helper = this.helperTable.get(layer)) == null) {
                Constructor<?> ctor;
                Class<?> clazz;
                if (Utils.isGridLayer(layer)) {
                    try {
                        clazz = Class.forName("org.geotools.swt.tool.GridLayerHelper");
                        ctor = clazz.getConstructor(MapContent.class, Layer.class);
                        helper = (InfoToolHelper)ctor.newInstance(context, layer);
                        this.helperTable.put(layer, helper);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Failed to create InfoToolHelper for grid layer", ex);
                    }
                }
                try {
                    clazz = Class.forName("org.geotools.swt.tool.VectorLayerHelper");
                    ctor = clazz.getConstructor(MapContent.class, Layer.class);
                    helper = (InfoToolHelper)ctor.newInstance(context, layer);
                    this.helperTable.put(layer, helper);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to create InfoToolHelper for vector layer", ex);
                }
            }
            Object info = null;
            if (helper instanceof VectorLayerHelper) {
                ReferencedEnvelope mapEnv = this.getMapPane().getDisplayArea();
                double searchWidth = 0.01 * (mapEnv.getWidth() + mapEnv.getHeight()) / 2.0;
                try {
                    info = helper.getInfo(pos, searchWidth);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                if (info == null) continue;
                SimpleFeatureIterator iter = null;
                SimpleFeatureCollection selectedFeatures = info;
                try {
                    iter = selectedFeatures.features();
                    while (iter.hasNext()) {
                        this.report(layerName, iter.next());
                    }
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                finally {
                    if (iter == null) continue;
                    iter.close();
                    continue;
                }
            }
            try {
                info = helper.getInfo(pos, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            if (info == null || (bandValues = (List)info).isEmpty()) continue;
            this.report(layerName, bandValues);
        }
    }

    private void report(DirectPosition2D pos) {
        this.createReporter();
        this.reporter.append(String.format("Pos \nx=%.4f \ny=%.4f\n\n", pos.x, pos.y));
    }

    private void report(String layerName, Feature feature) {
        this.createReporter();
        Collection props = feature.getProperties();
        String valueStr = null;
        StringBuilder sb = new StringBuilder();
        sb.append(layerName);
        sb.append("\n");
        for (Property prop : props) {
            String name = prop.getName().getLocalPart();
            Object value = prop.getValue();
            if (value instanceof Geometry) {
                name = "  Geometry";
                valueStr = value.getClass().getSimpleName();
            } else {
                valueStr = value.toString();
            }
            sb.append(name);
            sb.append(":");
            sb.append(valueStr);
            sb.append("\n\n");
        }
        this.reporter.append(sb.toString());
    }

    private void report(String layerName, List<Number> bandValues) {
        this.createReporter();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(layerName);
        sb.append("\n");
        int k = 1;
        for (Number value : bandValues) {
            sb.append(String.format("  Band %d: %s\n", k++, value.toString()));
        }
        sb.append("\n\n");
        this.reporter.append(sb.toString());
    }

    private void createReporter() {
        if (this.reporter == null || this.reporter.getShell() == null || this.reporter.getShell().isDisposed()) {
            Shell shell = new Shell(Display.getCurrent(), 2144);
            shell.setLayout((Layout)new GridLayout(1, false));
            this.reporter = new JTextReporter(shell, "Map info");
            this.reporter.open();
        }
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean canDraw() {
        return false;
    }

    @Override
    public boolean canMove() {
        return false;
    }
}

