/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.swt.tool.InfoToolHelper;
import org.geotools.swt.utils.Utils;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;

public class GridLayerHelper
extends InfoToolHelper<List<Number>> {
    protected final WeakReference<GridCoverage2D> covRef;

    public GridLayerHelper(MapContent content, Layer layer) {
        super(content, null);
        Object rasterSource = null;
        try {
            FeatureIterator iter = layer.getFeatureSource().getFeatures().features();
            String gridAttrName = Utils.getGridAttributeName(layer);
            rasterSource = iter.next().getProperty(gridAttrName).getValue();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to access raster feature data", ex);
        }
        GridCoverage2D cov = null;
        try {
            cov = GridCoverage2DReader.class.isAssignableFrom(rasterSource.getClass()) ? ((GridCoverage2DReader)rasterSource).read(null) : (GridCoverage2D)rasterSource;
            this.covRef = new WeakReference<GridCoverage2D>(cov);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        this.setCRS(cov.getCoordinateReferenceSystem());
    }

    @Override
    public List<Number> getInfo(DirectPosition2D pos, Object ... params) throws Exception {
        Object objArray;
        Number[] bandValues;
        DirectPosition2D trPos;
        GridCoverage2D cov;
        ReferencedEnvelope env;
        ArrayList<Number> list = new ArrayList<Number>();
        if (this.isValid() && (env = new ReferencedEnvelope((BoundingBox)(cov = (GridCoverage2D)this.covRef.get()).getEnvelope2D())).contains((DirectPosition)(trPos = this.getTransformed(pos))) && (bandValues = this.asNumberArray(objArray = cov.evaluate((DirectPosition)trPos))) != null) {
            for (Number value : bandValues) {
                list.add(value);
            }
        }
        return list;
    }

    @Override
    public boolean isValid() {
        return this.getMapContent() != null && this.covRef != null && this.covRef.get() != null;
    }

    private Number[] asNumberArray(Object objArray) {
        Number[] numbers;
        block5: {
            block7: {
                block6: {
                    block4: {
                        numbers = null;
                        if (!(objArray instanceof byte[])) break block4;
                        byte[] values = (byte[])objArray;
                        numbers = new Number[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            numbers[i] = values[i] & 0xFF;
                        }
                        break block5;
                    }
                    if (!(objArray instanceof int[])) break block6;
                    int[] values = (int[])objArray;
                    numbers = new Number[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        numbers[i] = values[i];
                    }
                    break block5;
                }
                if (!(objArray instanceof float[])) break block7;
                float[] values = (float[])objArray;
                numbers = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    numbers[i] = Float.valueOf(values[i]);
                }
                break block5;
            }
            if (!(objArray instanceof double[])) break block5;
            double[] values = (double[])objArray;
            numbers = new Number[values.length];
            for (int i = 0; i < values.length; ++i) {
                numbers[i] = values[i];
            }
        }
        return numbers;
    }

    private DirectPosition2D getTransformed(DirectPosition2D pos) {
        if (this.isTransformRequired()) {
            MathTransform tr = this.getTransform();
            if (tr == null) {
                throw new IllegalStateException("MathTransform should not be null");
            }
            try {
                return (DirectPosition2D)tr.transform((DirectPosition)pos, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return pos;
    }
}

