/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.event.MapMouseAdapter;
import org.geotools.swt.event.MapMouseEvent;
import org.geotools.swt.utils.CursorManager;
import org.geotools.swt.utils.Messages;

public abstract class CursorTool
extends MapMouseAdapter {
    public static final int ANY_BUTTON = SWT.BUTTON_MASK;
    private SwtMapPane mapPane;
    private int triggerButtonMask;

    public CursorTool(int triggerButtonMask) {
        this.triggerButtonMask = triggerButtonMask;
    }

    public CursorTool() {
        this(ANY_BUTTON);
    }

    public void setMapPane(SwtMapPane pane) {
        if (pane == null) {
            throw new IllegalArgumentException(Messages.getString("arg_null_error"));
        }
        this.mapPane = pane;
    }

    public SwtMapPane getMapPane() {
        return this.mapPane;
    }

    public Cursor getCursor() {
        return CursorManager.getInstance().getArrowCursor();
    }

    public abstract boolean canDraw();

    public abstract boolean canMove();

    public boolean isDrawing() {
        return this.canDraw();
    }

    protected boolean isTriggerMouseButton(MapMouseEvent event) {
        return this.triggerButtonMask == ANY_BUTTON || 0 != (this.triggerButtonMask & event.getStateMask()) || event.getStateMask() == 0 && ((this.triggerButtonMask & 0x80000) != 0 && event.getMouseButton() == 1 || (this.triggerButtonMask & 0x100000) != 0 && event.getMouseButton() == 2 || (this.triggerButtonMask & 0x200000) != 0 && event.getMouseButton() == 3 || (this.triggerButtonMask & 0x800000) != 0 && event.getMouseButton() == 4 || (this.triggerButtonMask & 0x2000000) != 0 && event.getMouseButton() == 5);
    }
}

