/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling.simple;

import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.swt.styling.simple.AbstractSimpleConfigurator;
import org.geotools.swt.utils.Messages;

public class ScaleViewer {
    public static final int MIN = 0;
    public static final int MAX = 1;
    boolean enabled;
    double scale;
    int type;
    Button on;
    Combo scaleEditor;
    Listener sync = new Listener();
    private SelectionListener listener;

    public ScaleViewer(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Type should be either MIN or MAX");
        }
        this.type = type;
        this.scale = type == 0 ? 0.0 : Double.MAX_VALUE;
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public Composite createControl(Composite parent, KeyListener kListener) {
        String labelId = this.type == 0 ? Messages.getString("SimpleStyleConfigurator_minscaleden_label") : Messages.getString("SimpleStyleConfigurator_maxscaleden_label");
        Composite part = AbstractSimpleConfigurator.subpart(parent, labelId);
        this.on = new Button(part, 32);
        this.on.addSelectionListener((SelectionListener)this.sync);
        this.scaleEditor = new Combo(part, 4);
        this.scaleEditor.setItems(new String[]{"100", "1000", "10000", "100000", "1000000", "10000000"});
        this.scaleEditor.setTextLimit(10);
        this.scaleEditor.addKeyListener(kListener);
        String tooltip = this.type == 0 ? Messages.getString("ScaleViewer_minscaleden_tooltip") : Messages.getString("ScaleViewer_maxscaleden_tooltip");
        this.scaleEditor.setToolTipText(tooltip);
        return part;
    }

    public double getScale() {
        if (!this.enabled) {
            return this.type == 0 ? 0.0 : Double.MAX_VALUE;
        }
        return this.scale;
    }

    public void setScale(double scale2, long defaultScale) {
        this.listen(false);
        this.scale = scale2;
        this.enabled = true;
        if (Double.isNaN(this.scale) || Double.isInfinite(this.scale) || this.scale <= Double.MIN_VALUE || this.scale >= Double.MAX_VALUE) {
            this.scale = defaultScale;
            this.enabled = false;
        }
        this.scaleEditor.setText(Double.toString(this.scale));
        this.on.setSelection(this.enabled);
        this.scaleEditor.setEnabled(this.enabled);
        this.listen(true);
    }

    void listen(boolean listen) {
        if (listen) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.scaleEditor.addSelectionListener((SelectionListener)this.sync);
            this.scaleEditor.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.scaleEditor.removeSelectionListener((SelectionListener)this.sync);
            this.scaleEditor.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sync(SelectionEvent selectionEvent) {
            try {
                ScaleViewer.this.enabled = ScaleViewer.this.on.getSelection();
                String ptext = ScaleViewer.this.scaleEditor.getText();
                ScaleViewer.this.scale = Double.parseDouble(ptext);
                ScaleViewer.this.fire(selectionEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                ScaleViewer.this.scaleEditor.setEnabled(ScaleViewer.this.enabled);
            }
        }
    }
}

