/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling.simple;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.FontData;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.Filters;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.SemanticType;

public class SLDs
extends SLD {
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final double ALIGN_LEFT = 1.0;
    public static final double ALIGN_CENTER = 0.5;
    public static final double ALIGN_RIGHT = 0.0;
    public static final double ALIGN_BOTTOM = 1.0;
    public static final double ALIGN_MIDDLE = 0.5;
    public static final double ALIGN_TOP = 0.0;
    public static final String GENERIC_FEATURE_TYPENAME = "Feature";

    public static int size(org.opengis.style.Graphic graphic) {
        if (graphic == null) {
            return -1;
        }
        return Filters.asInt(graphic.getSize());
    }

    public static Color polyFill(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return null;
        }
        Expression color = fill.getColor();
        return SLDs.color(color);
    }

    public static Color color(Expression expr) {
        if (expr == null) {
            return null;
        }
        try {
            return (Color)expr.evaluate(null, Color.class);
        }
        catch (Throwable t) {
            class ColorVisitor
            implements ExpressionVisitor {
                Color found;

                ColorVisitor() {
                }

                public Object visit(Literal expr, Object data) {
                    if (this.found != null) {
                        return null;
                    }
                    try {
                        Color color = (Color)expr.evaluate((Object)expr, Color.class);
                        if (color != null) {
                            this.found = color;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return data;
                }

                public Object visit(NilExpression arg0, Object data) {
                    return data;
                }

                public Object visit(Add arg0, Object data) {
                    return data;
                }

                public Object visit(Divide arg0, Object data) {
                    return null;
                }

                public Object visit(Function function, Object data) {
                    for (Expression param : function.getParameters()) {
                        param.accept((ExpressionVisitor)this, data);
                    }
                    return data;
                }

                public Object visit(Multiply arg0, Object data) {
                    return data;
                }

                public Object visit(PropertyName arg0, Object data) {
                    return data;
                }

                public Object visit(Subtract arg0, Object data) {
                    return data;
                }
            }
            ColorVisitor search = new ColorVisitor();
            expr.accept((ExpressionVisitor)search, null);
            return search.found;
        }
    }

    public static FontData[] textFont(TextSymbolizer symbolizer) {
        Font font = SLDs.font(symbolizer);
        if (font == null) {
            return null;
        }
        FontData[] tempFD = new FontData[1];
        Expression fontFamilyExpression = (Expression)font.getFamily().get(0);
        Expression sizeExpression = font.getSize();
        if (sizeExpression == null || fontFamilyExpression == null) {
            return null;
        }
        Double size = (Double)sizeExpression.evaluate(null, Double.class);
        try {
            String fontFamily = (String)fontFamilyExpression.evaluate(null, String.class);
            tempFD[0] = new FontData(fontFamily, size.intValue(), 1);
        }
        catch (NullPointerException ignore) {
            return null;
        }
        if (tempFD[0] != null) {
            return tempFD;
        }
        return null;
    }

    public static String[] colors(Rule rule) {
        HashSet<String> colorSet = new HashSet<String>();
        Color color = null;
        for (Symbolizer sym : rule.symbolizers()) {
            PolygonSymbolizer symb;
            if (sym instanceof PolygonSymbolizer) {
                symb = (PolygonSymbolizer)sym;
                color = SLDs.polyFill(symb);
            } else if (sym instanceof LineSymbolizer) {
                symb = (LineSymbolizer)sym;
                color = SLDs.color((LineSymbolizer)symb);
            } else if (sym instanceof PointSymbolizer) {
                symb = (PointSymbolizer)sym;
                color = SLDs.pointFillWithAlpha((PointSymbolizer)symb);
            }
            if (color == null) continue;
            colorSet.add(SLD.colorToHex(color));
        }
        if (colorSet.size() > 0) {
            return colorSet.toArray(new String[0]);
        }
        return new String[0];
    }

    public static Color pointFillWithAlpha(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Mark mark;
            Fill fill;
            if (gs == null || !(gs instanceof Mark) || (fill = (mark = (Mark)gs).getFill()) == null) continue;
            Color colour = SLDs.color(fill.getColor());
            if (colour == null) {
                return null;
            }
            Expression opacity = fill.getOpacity();
            if (opacity == null) {
                opacity = ff.literal(1.0);
            }
            float alpha = (float)Filters.asDouble(opacity);
            if ((colour = new Color((float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, alpha)) == null) continue;
            return colour;
        }
        return null;
    }

    public static Color pointStrokeColorWithAlpha(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Mark mark;
            Stroke stroke;
            if (gs == null || !(gs instanceof Mark) || (stroke = (mark = (Mark)gs).getStroke()) == null) continue;
            Color colour = SLDs.color(stroke);
            if (colour == null) {
                return null;
            }
            Expression opacity = stroke.getOpacity();
            if (opacity == null) {
                opacity = ff.literal(1.0);
            }
            float alpha = (float)Filters.asDouble(opacity);
            if ((colour = new Color((float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, alpha)) == null) continue;
            return colour;
        }
        return null;
    }

    public static Font font(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Font font = symbolizer.getFont();
        return font;
    }

    public static Style getDefaultStyle(StyledLayerDescriptor sld) {
        Style[] styles = SLDs.styles(sld);
        for (int i = 0; i < styles.length; ++i) {
            Style style = styles[i];
            List ftStyles = style.featureTypeStyles();
            SLDs.genericizeftStyles(ftStyles);
            if (!style.isDefault()) continue;
            return style;
        }
        return styles[0];
    }

    private static void genericizeftStyles(List<FeatureTypeStyle> ftStyles) {
        for (FeatureTypeStyle featureTypeStyle : ftStyles) {
            featureTypeStyle.featureTypeNames().clear();
            featureTypeStyle.featureTypeNames().add(new NameImpl(GENERIC_FEATURE_TYPENAME));
        }
    }

    public static boolean isSemanticTypeMatch(FeatureTypeStyle fts, String regex) {
        Set identifiers = fts.semanticTypeIdentifiers();
        for (SemanticType semanticType : identifiers) {
            if (!semanticType.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static double minScale(FeatureTypeStyle fts) {
        if (fts == null || fts.rules().size() == 0) {
            return 0.0;
        }
        Rule r = (Rule)fts.rules().get(0);
        return r.getMinScaleDenominator();
    }

    public static double maxScale(FeatureTypeStyle fts) {
        if (fts == null || fts.rules().size() == 0) {
            return Double.NaN;
        }
        Rule r = (Rule)fts.rules().get(0);
        return r.getMaxScaleDenominator();
    }

    public static FeatureTypeStyle getFeatureTypeStyle(Style s) {
        List fts = s.featureTypeStyles();
        if (fts.size() > 0) {
            return (FeatureTypeStyle)fts.get(0);
        }
        return null;
    }

    public static Rule getRasterSymbolizerRule(Style s) {
        List fts = s.featureTypeStyles();
        for (int i = 0; i < fts.size(); ++i) {
            FeatureTypeStyle featureTypeStyle = (FeatureTypeStyle)fts.get(i);
            List rules = featureTypeStyle.rules();
            for (int j = 0; j < rules.size(); ++j) {
                Rule rule = (Rule)rules.get(j);
                Symbolizer[] symbolizers = rule.getSymbolizers();
                for (int k = 0; k < symbolizers.length; ++k) {
                    Symbolizer symbolizer = symbolizers[k];
                    if (!(symbolizer instanceof RasterSymbolizer)) continue;
                    return rule;
                }
            }
        }
        return null;
    }

    public static final boolean isPolygon(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SLDs.isPolygon(featureType.getGeometryDescriptor());
    }

    public static final boolean isPolygon(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
    }

    public static final boolean isLine(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SLDs.isLine(featureType.getGeometryDescriptor());
    }

    public static final boolean isLine(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return LineString.class.isAssignableFrom(type) || MultiLineString.class.isAssignableFrom(type);
    }

    public static final boolean isPoint(SimpleFeatureType featureType) {
        if (featureType == null) {
            return false;
        }
        return SLDs.isPoint(featureType.getGeometryDescriptor());
    }

    public static final boolean isPoint(GeometryDescriptor geometryType) {
        if (geometryType == null) {
            return false;
        }
        Class type = geometryType.getType().getBinding();
        return Point.class.isAssignableFrom(type) || MultiPoint.class.isAssignableFrom(type);
    }
}

