/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling.simple;

import java.text.MessageFormat;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.StyleBuilder;
import org.geotools.swt.styling.simple.AbstractSimpleConfigurator;
import org.geotools.swt.utils.Messages;

public class OpacityViewer {
    double opacity = Double.NaN;
    private Combo percent;
    private SelectionListener listener;
    Listener sync = new Listener();

    public Composite createControl(Composite parent, KeyListener listener1) {
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.getString("SimpleStyleConfigurator_raster_label"));
        this.percent = new Combo(part, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(4);
        this.percent.addKeyListener(listener1);
        this.percent.setToolTipText(Messages.getString("RasterViewer_percent_tooltip"));
        return part;
    }

    void listen(boolean listen) {
        if (listen) {
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(RasterSymbolizer sym2) {
        this.listen(false);
        try {
            RasterSymbolizer sym = sym2;
            this.opacity = sym == null ? 1.0 : SLD.rasterOpacity(sym);
            String text = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText(text);
            this.percent.select(this.percent.indexOf(text));
        }
        finally {
            this.listen(true);
        }
    }

    public RasterSymbolizer get(StyleBuilder build) {
        return Double.isNaN(this.opacity) ? null : build.createRasterSymbolizer(null, this.opacity);
    }

    public double getValue() {
        return this.opacity;
    }

    private class Listener
    implements ModifyListener {
        private Listener() {
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        private void sync(SelectionEvent e) {
            try {
                try {
                    String ptext = OpacityViewer.this.percent.getText();
                    if (ptext.endsWith("%")) {
                        ptext = ptext.substring(0, ptext.length() - 1);
                        OpacityViewer.this.opacity = Double.parseDouble(ptext);
                        OpacityViewer.this.opacity /= 100.0;
                    } else {
                        OpacityViewer.this.opacity = Double.parseDouble(ptext);
                        if (OpacityViewer.this.opacity > 1.0) {
                            OpacityViewer.this.opacity /= 100.0;
                        }
                    }
                }
                catch (NumberFormatException nan) {
                    // empty catch block
                }
                OpacityViewer.this.fire(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

