/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling.simple;

import java.awt.Color;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.geotools.swt.utils.Messages;

public class FontEditor {
    private Image fImage = null;
    private RGB fColorValue;
    private org.eclipse.swt.graphics.Color[] fColor = null;
    private Font[] fFont = null;
    private FontData[] fFontList = null;
    private Button fButton;
    private SelectionListener parentListener;
    final FontDialog labelFontDialog;

    public FontEditor(Composite parent) {
        this(parent, null);
    }

    public FontEditor(Composite parent, SelectionListener parentListener) {
        this.parentListener = parentListener;
        this.fButton = new Button(parent, 8);
        this.fFont = new Font[1];
        this.fColor = new org.eclipse.swt.graphics.Color[1];
        this.fButton.setText(Messages.getString("FontEditor_SetFont"));
        this.labelFontDialog = new FontDialog(new Shell());
        this.labelFontDialog.setText("Choose a Font");
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb;
                FontData[] list;
                FontEditor.this.labelFontDialog.setRGB(FontEditor.this.fColorValue);
                FontEditor.this.labelFontDialog.setFontList(FontEditor.this.fFontList);
                if (FontEditor.this.labelFontDialog.open() == null) {
                    return;
                }
                if (FontEditor.this.fFont[0] != null) {
                    FontEditor.this.fFont[0].dispose();
                }
                if ((list = FontEditor.this.labelFontDialog.getFontList()) != null) {
                    ((FontEditor)FontEditor.this).fFont[0] = new Font((Device)FontEditor.this.fButton.getDisplay(), list);
                    FontEditor.access$102(FontEditor.this, list);
                }
                if ((rgb = FontEditor.this.labelFontDialog.getRGB()) != null) {
                    if (FontEditor.this.fColor[0] != null) {
                        FontEditor.this.fColor[0].dispose();
                    }
                    ((FontEditor)FontEditor.this).fColor[0] = new org.eclipse.swt.graphics.Color((Device)FontEditor.this.fButton.getDisplay(), rgb);
                    FontEditor.this.fColorValue = rgb;
                    FontEditor.this.updateColorImage();
                }
                FontEditor.this.notifyParent(event);
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (FontEditor.this.fImage != null) {
                    FontEditor.this.fImage.dispose();
                    FontEditor.this.fImage = null;
                }
                if (FontEditor.this.fColor != null) {
                    if (FontEditor.this.fColor[0] != null) {
                        FontEditor.this.fColor[0].dispose();
                    }
                    FontEditor.access$402(FontEditor.this, null);
                }
                if (FontEditor.this.fFont != null) {
                    if (FontEditor.this.fFont[0] != null) {
                        FontEditor.this.fFont[0].dispose();
                    }
                    FontEditor.access$202(FontEditor.this, null);
                }
            }
        });
    }

    public void setListener(SelectionListener parentListener) {
        this.parentListener = parentListener;
    }

    public void clearListener() {
        this.parentListener = null;
    }

    private void notifyParent(SelectionEvent event) {
        if (this.parentListener != null) {
            this.parentListener.widgetSelected(event);
        }
    }

    public org.eclipse.swt.graphics.Color getColor() {
        return this.fColor[0];
    }

    public Color getAWTColor() {
        org.eclipse.swt.graphics.Color tmpColor = this.getColor();
        if (tmpColor == null) {
            return null;
        }
        return new Color(tmpColor.getRed(), tmpColor.getGreen(), tmpColor.getBlue());
    }

    public Font getFont() {
        return this.fFont[0];
    }

    public FontData[] getFontList() {
        return this.fFontList;
    }

    public void setFontList(FontData[] list) {
        if (list != null) {
            this.fFontList = list;
            this.fFont[0] = new Font((Device)this.fButton.getDisplay(), list);
            this.labelFontDialog.setFontList(list);
        }
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rgb) {
        this.fColorValue = rgb;
        this.fColor[0] = new org.eclipse.swt.graphics.Color((Device)this.fButton.getDisplay(), rgb);
        this.labelFontDialog.setRGB(rgb);
        this.updateColorImage();
    }

    public void setColorValue(Color colour) {
        if (colour != null) {
            this.setColorValue(new RGB(colour.getRed(), colour.getGreen(), colour.getBlue()));
        }
    }

    public Button getButton() {
        return this.fButton;
    }

    private void updateColorImage() {
    }

    public void setEnabled(boolean enabled) {
        this.fButton.setEnabled(enabled);
    }

    static /* synthetic */ FontData[] access$102(FontEditor x0, FontData[] x1) {
        x0.fFontList = x1;
        return x1;
    }

    static /* synthetic */ org.eclipse.swt.graphics.Color[] access$402(FontEditor x0, org.eclipse.swt.graphics.Color[] x1) {
        x0.fColor = x1;
        return x1;
    }

    static /* synthetic */ Font[] access$202(FontEditor x0, Font[] x1) {
        x0.fFont = x1;
        return x1;
    }
}

