/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling.simple;

import java.awt.Color;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.geotools.styling.Fill;
import org.geotools.styling.SLD;
import org.geotools.styling.StyleBuilder;
import org.geotools.swt.styling.simple.AbstractSimpleConfigurator;
import org.geotools.swt.styling.simple.Mode;
import org.geotools.swt.styling.simple.StolenColorEditor;
import org.geotools.swt.utils.Messages;

public class FillViewer {
    boolean enabled;
    Color color;
    double opacity;
    Button on;
    StolenColorEditor chooser;
    Combo percent;
    Listener sync = new Listener();
    private SelectionListener listener;

    public void addListener(SelectionListener listener1) {
        this.listener = listener1;
    }

    public void removeListener(SelectionListener listener1) {
        if (this.listener == listener1) {
            this.listener = null;
        }
    }

    protected void fire(SelectionEvent event) {
        if (this.listener == null) {
            return;
        }
        this.listener.widgetSelected(event);
    }

    public Composite createControl(Composite parent, KeyListener kListener) {
        Composite part = AbstractSimpleConfigurator.subpart(parent, Messages.getString("SimpleStyleConfigurator_fill_label"));
        this.on = new Button(part, 32);
        this.on.addSelectionListener((SelectionListener)this.sync);
        this.chooser = new StolenColorEditor(part, this.sync);
        this.percent = new Combo(part, 4);
        this.percent.setItems(new String[]{"0%", "25%", "50%", "75%", "100%"});
        this.percent.setTextLimit(4);
        this.percent.addKeyListener(kListener);
        this.percent.setToolTipText(Messages.getString("FillViewer_percent_tooltip"));
        return part;
    }

    public Fill getFill(StyleBuilder build) {
        if (!this.enabled) {
            return null;
        }
        if (!Double.isNaN(this.opacity)) {
            return build.createFill(this.color, this.opacity);
        }
        return build.createFill(this.color);
    }

    void listen(boolean listen) {
        if (listen) {
            this.on.addSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(this.sync);
            this.percent.addSelectionListener((SelectionListener)this.sync);
            this.percent.addModifyListener((ModifyListener)this.sync);
        } else {
            this.on.removeSelectionListener((SelectionListener)this.sync);
            this.chooser.setListener(null);
            this.percent.removeSelectionListener((SelectionListener)this.sync);
            this.percent.removeModifyListener((ModifyListener)this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFill(Fill fill2, Mode mode, Color defaultColor) {
        this.listen(false);
        try {
            boolean enabled = true;
            Fill fill = fill2;
            if (fill == null) {
                StyleBuilder builder = new StyleBuilder();
                fill = builder.createFill(defaultColor, 0.5);
                enabled = false;
            }
            this.enabled = enabled && mode != Mode.NONE && mode != Mode.LINE && fill != null;
            this.color = SLD.color(fill);
            this.opacity = SLD.opacity(fill);
            this.on.setEnabled(mode != Mode.NONE && mode != Mode.LINE);
            this.chooser.setColor(this.color);
            String text = MessageFormat.format("{0,number,#0%}", this.opacity);
            this.percent.setText(text);
            this.percent.select(this.percent.indexOf(text));
            this.on.setSelection(this.enabled);
            this.chooser.setEnabled(this.enabled);
            this.percent.setEnabled(this.enabled);
        }
        finally {
            this.listen(true);
        }
    }

    private class Listener
    implements SelectionListener,
    ModifyListener {
        private Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.sync(e);
        }

        public void modifyText(ModifyEvent e) {
            this.sync(AbstractSimpleConfigurator.selectionEvent(e));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sync(SelectionEvent selectionEvent) {
            try {
                FillViewer.this.enabled = FillViewer.this.on.getSelection();
                FillViewer.this.color = FillViewer.this.chooser.getColor();
                String ptext = FillViewer.this.percent.getText();
                if (ptext.endsWith("%")) {
                    ptext = ptext.substring(0, ptext.length() - 1);
                    FillViewer.this.opacity = Double.parseDouble(ptext) / 100.0;
                } else {
                    FillViewer.this.opacity = Double.parseDouble(ptext);
                    if (FillViewer.this.opacity > 1.0) {
                        FillViewer.this.opacity /= 100.0;
                    }
                }
                FillViewer.this.fire(selectionEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                FillViewer.this.chooser.setEnabled(FillViewer.this.enabled);
                FillViewer.this.percent.setEnabled(FillViewer.this.enabled);
            }
        }
    }
}

