/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling.simple;

import java.awt.Color;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.swt.styling.simple.SLDs;
import org.opengis.feature.simple.SimpleFeatureType;

public class AbstractSimpleConfigurator
extends Dialog {
    protected StyleBuilder build = new StyleBuilder();
    protected SimpleFeatureCollection featureCollection;
    protected Style style;

    public AbstractSimpleConfigurator(Shell parent, SimpleFeatureCollection featureCollection, Style style) {
        super(parent);
        this.featureCollection = featureCollection;
        this.style = style;
    }

    protected void setLayout(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.pack = false;
        layout.wrap = true;
        layout.type = 256;
        layout.fill = true;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
    }

    protected Style getStyle() {
        assert (this.featureCollection != null);
        Style style = this.style;
        if (style == null) {
            SimpleFeatureType schema = (SimpleFeatureType)this.featureCollection.getSchema();
            if (SLDs.isLine(schema)) {
                style = SLD.createLineStyle(Color.red, 1.0f);
            } else if (SLDs.isPoint(schema)) {
                style = SLD.createPointStyle("Circle", Color.red, Color.green, 1.0f, 3.0f);
            } else if (SLDs.isPolygon(schema)) {
                style = SLD.createPolygonStyle(Color.red, Color.green, 1.0f);
            }
        }
        this.style = style;
        return style;
    }

    public static Composite subpart(Composite parent, String label) {
        Composite subpart = new Composite(parent, 0);
        RowLayout across = new RowLayout();
        across.type = 256;
        across.wrap = true;
        across.pack = true;
        across.fill = true;
        across.marginBottom = 1;
        across.marginRight = 2;
        subpart.setLayout((Layout)across);
        Label labell = new Label(subpart, 16384);
        labell.setText(label);
        RowData data = new RowData();
        data.width = 40;
        GC gc = new GC((Drawable)parent.getParent());
        gc.setFont(parent.getParent().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int labelWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)(labell.getText().length() + 1));
        if (labelWidth > data.width) {
            data.width = labelWidth;
        }
        data.height = 10;
        labell.setLayoutData((Object)data);
        return subpart;
    }

    public static SelectionEvent selectionEvent(final ModifyEvent e) {
        Event event = new Event();
        event.widget = e.widget;
        event.data = e.data;
        event.display = e.display;
        event.time = e.time;
        return new SelectionEvent(event){
            private static final long serialVersionUID = 6544345585295778029L;

            public Object getSource() {
                return e.getSource();
            }
        };
    }
}

