/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.styling;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.map.Layer;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.swt.styling.simple.AbstractSimpleConfigurator;
import org.geotools.swt.styling.simple.FillViewer;
import org.geotools.swt.styling.simple.GraphicViewer;
import org.geotools.swt.styling.simple.LabelViewer;
import org.geotools.swt.styling.simple.Mode;
import org.geotools.swt.styling.simple.SLDs;
import org.geotools.swt.styling.simple.ScaleViewer;
import org.geotools.swt.styling.simple.StrokeViewer;
import org.geotools.swt.utils.Messages;
import org.geotools.swt.utils.Utils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.style.LabelPlacement;

public class SimpleStyleConfigurator
extends AbstractSimpleConfigurator {
    private static final String DEFAULT_GEOMETRY = "(default)";
    public static StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    private ComboViewer geometryName;
    private Button pointMode;
    private Button polyMode;
    private Button lineMode;
    private StrokeViewer line = new StrokeViewer();
    private FillViewer fill = new FillViewer();
    private GraphicViewer point = new GraphicViewer();
    private LabelViewer label = new LabelViewer();
    private ScaleViewer minScale = new ScaleViewer(0);
    private ScaleViewer maxScale = new ScaleViewer(1);
    private Mode mode;
    private SelectionListener synchronize = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SimpleStyleConfigurator.this.synchronize();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SimpleStyleConfigurator.this.synchronize();
        }
    };
    private Button replace;

    public SimpleStyleConfigurator(Shell parent, SimpleFeatureCollection featureCollection, Style style) {
        super(parent, featureCollection, style);
        this.line.addListener(this.synchronize);
        this.fill.addListener(this.synchronize);
        this.label.addListener(this.synchronize);
        this.point.addListener(this.synchronize);
        this.minScale.addListener(this.synchronize);
        this.maxScale.addListener(this.synchronize);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("");
    }

    protected Point getInitialSize() {
        return new Point(450, 370);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentPanel = (Composite)super.createDialogArea(parent);
        this.setLayout(parentPanel);
        ((RowLayout)parentPanel.getLayout()).type = 512;
        ((RowLayout)parentPanel.getLayout()).spacing = 3;
        KeyAdapter adp = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.character == '\r') {
                    SimpleStyleConfigurator.this.refresh();
                }
            }
        };
        Composite part = AbstractSimpleConfigurator.subpart(parentPanel, Messages.getString("SimpleStyleConfigurator_GeometryLabel"));
        this.geometryName = new ComboViewer(part);
        this.geometryName.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            FeatureType schema;

            public Object[] getElements(Object inputElement) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(SimpleStyleConfigurator.DEFAULT_GEOMETRY);
                if (this.schema != null) {
                    for (PropertyDescriptor descriptor : this.schema.getDescriptors()) {
                        if (!(descriptor instanceof GeometryDescriptor)) continue;
                        names.add(((GeometryDescriptor)descriptor).getLocalName());
                    }
                }
                return names.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.schema = (FeatureType)newInput;
            }

            public void dispose() {
            }
        });
        this.geometryName.getCombo().setText(DEFAULT_GEOMETRY);
        this.geometryName.getCombo().addSelectionListener(this.synchronize);
        part = AbstractSimpleConfigurator.subpart(parentPanel, Messages.getString("SimpleStyleConfigurator_ModeLabel"));
        this.pointMode = new Button(part, 16);
        this.pointMode.setText(Messages.getString("SimpleStyleConfigurator_PointMode"));
        this.lineMode = new Button(part, 16);
        this.lineMode.setText(Messages.getString("SimpleStyleConfigurator_LineMode"));
        this.polyMode = new Button(part, 16);
        this.polyMode.setText(Messages.getString("SimpleStyleConfigurator_PolygonMode"));
        this.line.createControl(parentPanel, (KeyListener)adp);
        this.fill.createControl(parentPanel, (KeyListener)adp);
        this.point.createControl(parentPanel, (KeyListener)adp, this.build);
        this.label.createControl(parentPanel, (KeyListener)adp);
        this.minScale.createControl(parentPanel, (KeyListener)adp);
        this.maxScale.createControl(parentPanel, (KeyListener)adp);
        Composite replaceComp = AbstractSimpleConfigurator.subpart(parentPanel, Messages.getString("SimpleStyleConfigurator_replaceButton"));
        this.replace = new Button(replaceComp, 32);
        this.replace.addSelectionListener(this.synchronize);
        this.replace.setSelection(true);
        this.refresh();
        return parentPanel;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                String styleToString = SimpleStyleConfigurator.styleToString(this.style);
                System.out.println(styleToString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.buttonPressed(buttonId);
    }

    public static String styleToString(Style style) throws Exception {
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[]{null});
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = aTransformer.transform(sld);
        return xml;
    }

    public Mode determineMode(SimpleFeatureType schema, boolean askUser) {
        if (schema == null) {
            return Mode.NONE;
        }
        if (SLDs.isLine(schema)) {
            return Mode.LINE;
        }
        if (SLDs.isPolygon(schema)) {
            return Mode.POLYGON;
        }
        if (SLDs.isPoint(schema)) {
            return Mode.POINT;
        }
        if (askUser) {
            if (this.polyMode.getSelection()) {
                return Mode.POLYGON;
            }
            if (this.lineMode.getSelection()) {
                return Mode.LINE;
            }
            if (this.pointMode.getSelection()) {
                return Mode.POINT;
            }
        }
        return Mode.ALL;
    }

    protected void refresh() {
        LineSymbolizer sym;
        Style style = this.getStyle();
        List ftsList = style.featureTypeStyles();
        FeatureTypeStyle fts = null;
        if (ftsList.size() > 0) {
            fts = (FeatureTypeStyle)ftsList.get(0);
        }
        SimpleFeatureType schema = (SimpleFeatureType)this.featureCollection.getSchema();
        this.geometryName.setInput((Object)schema);
        String name = DEFAULT_GEOMETRY;
        Stroke stroke = null;
        Fill fill = null;
        Graphic graphic = null;
        TextSymbolizer text = null;
        PointPlacement placement = null;
        List rules = Collections.emptyList();
        if (fts != null) {
            rules = fts.rules();
        }
        if (rules.size() > 1) {
            Rule keepRule = (Rule)rules.get(0);
            rules.clear();
            rules.add(keepRule);
        }
        this.mode = this.determineMode(schema, true);
        if (this.mode == Mode.NONE) {
            this.pointMode.setSelection(false);
            this.polyMode.setSelection(false);
            this.lineMode.setSelection(false);
        } else if (this.mode == Mode.LINE) {
            this.lineMode.setSelection(true);
            sym = SLDs.lineSymbolizer(fts);
            stroke = SLDs.stroke(sym);
            placement = SLDs.getPlacement(1.0, 0.5, 0.0);
            name = sym == null ? null : sym.getGeometryPropertyName();
        } else if (this.mode == Mode.POLYGON) {
            this.polyMode.setSelection(true);
            sym = SLDs.polySymbolizer(fts);
            stroke = SLDs.stroke((PolygonSymbolizer)sym);
            fill = SLDs.fill((PolygonSymbolizer)sym);
            placement = SLDs.getPlacement(0.5, 0.5, 0.0);
            name = sym == null ? null : sym.getGeometryPropertyName();
        } else if (this.mode == Mode.POINT || this.mode == Mode.ALL) {
            this.pointMode.setSelection(true);
            sym = SLDs.pointSymbolizer(fts);
            stroke = SLDs.stroke((PointSymbolizer)sym);
            fill = SLDs.fill((PointSymbolizer)sym);
            graphic = SLDs.graphic((PointSymbolizer)sym);
            placement = SLDs.getPlacement(1.0, 0.5, 0.0);
            name = sym == null ? null : sym.getGeometryPropertyName();
        }
        text = SLDs.textSymbolizer(fts);
        if (text != null && placement != null) {
            text.setLabelPlacement((LabelPlacement)placement);
        }
        if (name == null) {
            name = DEFAULT_GEOMETRY;
            this.geometryName.getCombo().setText(name);
        } else {
            this.geometryName.getCombo().setText(name);
        }
        Mode raw = this.determineMode(schema, false);
        this.pointMode.setEnabled(raw == Mode.ALL);
        this.polyMode.setEnabled(raw == Mode.ALL);
        this.lineMode.setEnabled(raw == Mode.ALL);
        double minScaleDen = SLDs.minScale(fts);
        double maxScaleDen = SLDs.maxScale(fts);
        Color defaultColor = Color.red;
        this.line.setStroke(stroke, this.mode, defaultColor);
        this.fill.setFill(fill, this.mode, defaultColor);
        this.point.setGraphic(graphic, this.mode, defaultColor);
        this.label.set(schema, text, this.mode);
        this.minScale.setScale(minScaleDen, 0L);
        this.maxScale.setScale(maxScaleDen, 1111111L);
    }

    public void synchronize() {
        ArrayList<Object> acquire = new ArrayList<Object>();
        TextSymbolizer textSym = this.label.get(this.build);
        SimpleFeatureType schema = (SimpleFeatureType)this.featureCollection.getSchema();
        this.mode = this.determineMode(schema, true);
        String geometryPropertyName = null;
        if (this.geometryName.getCombo().getSelectionIndex() != 0) {
            geometryPropertyName = this.geometryName.getCombo().getText();
        }
        switch (this.mode) {
            case LINE: {
                LineSymbolizer lineSymbolizer = this.build.createLineSymbolizer(this.line.getStroke(this.build));
                acquire.add(lineSymbolizer);
                lineSymbolizer.setGeometryPropertyName(geometryPropertyName);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
            case POLYGON: {
                PolygonSymbolizer polygonSymbolizer = this.build.createPolygonSymbolizer(this.line.getStroke(this.build), this.fill.getFill(this.build));
                polygonSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(polygonSymbolizer);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
            case POINT: {
                PointSymbolizer pointSymbolizer = this.build.createPointSymbolizer(this.point.getGraphic(this.fill.getFill(this.build), this.line.getStroke(this.build), this.build));
                pointSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(pointSymbolizer);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
            case ALL: {
                LineSymbolizer lineSymbolizer = this.build.createLineSymbolizer(this.line.getStroke(this.build));
                acquire.add(lineSymbolizer);
                acquire.add(lineSymbolizer);
                PolygonSymbolizer polygonSymbolizer = this.build.createPolygonSymbolizer(this.line.getStroke(this.build), this.fill.getFill(this.build));
                polygonSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(polygonSymbolizer);
                PointSymbolizer pointSymbolizer = this.build.createPointSymbolizer(this.point.getGraphic(this.fill.getFill(this.build), this.line.getStroke(this.build), this.build));
                pointSymbolizer.setGeometryPropertyName(geometryPropertyName);
                acquire.add(pointSymbolizer);
                if (textSym == null) break;
                acquire.add(textSym);
                break;
            }
        }
        double minScaleDen = this.minScale.getScale();
        double maxScaleDen = this.maxScale.getScale();
        Symbolizer[] array = acquire.toArray(new Symbolizer[acquire.size()]);
        Rule rule = this.build.createRule(array);
        if (this.minScale.isEnabled()) {
            rule.setMinScaleDenominator(minScaleDen);
        }
        if (this.maxScale.isEnabled()) {
            rule.setMaxScaleDenominator(maxScaleDen);
        }
        FeatureTypeStyle featureTypeStyle = this.build.createFeatureTypeStyle("Feature", rule);
        featureTypeStyle.setName("simple");
        Style style = this.getStyle();
        style.setDefault(true);
        if (this.replace.getSelection()) {
            style.featureTypeStyles().clear();
            style.featureTypeStyles().add(featureTypeStyle);
        } else {
            List fts = style.featureTypeStyles();
            boolean match = false;
            for (int i = fts.size() - 1; i > -1; --i) {
                if (!SLDs.isSemanticTypeMatch((FeatureTypeStyle)fts.get(i), "simple")) continue;
                fts.set(i, featureTypeStyle);
                match = true;
                break;
            }
            if (match) {
                style.featureTypeStyles().clear();
                style.featureTypeStyles().addAll(fts);
            } else {
                ArrayList<FeatureTypeStyle> fts2 = new ArrayList<FeatureTypeStyle>(fts);
                Collections.copy(fts2, fts);
                fts2.add(featureTypeStyle);
                style.featureTypeStyles().clear();
                style.featureTypeStyles().addAll(fts2);
            }
        }
        this.style = style;
    }

    public static Style showDialog(Shell parent, Layer layer) throws IOException {
        if (!Utils.isGridLayer(layer)) {
            SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeatureSource();
            Style style = layer.getStyle();
            SimpleStyleConfigurator.showDialog(parent, featureSource, style);
        }
        return null;
    }

    public static Style showDialog(Shell parent, SimpleFeatureSource featureSource, Style style) throws IOException {
        SimpleFeatureCollection features = featureSource.getFeatures();
        SimpleStyleConfigurator tmp = new SimpleStyleConfigurator(parent, features, style);
        tmp.setBlockOnOpen(true);
        tmp.open();
        return tmp.getStyle();
    }
}

