/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.event;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.swt.SwtMapPane;

public final class MapMouseEvent {
    private DirectPosition2D geoCoords;
    private boolean isWheelEvent;
    private int wheelAmount;
    private final MouseEvent event;

    public MapMouseEvent(SwtMapPane pane, MouseEvent event, boolean isWheel) {
        this.event = event;
        this.isWheelEvent = isWheel;
        this.wheelAmount = !isWheel ? 0 : event.count;
        AffineTransform tr = pane.getScreenToWorldTransform();
        this.geoCoords = new DirectPosition2D((double)event.x, (double)event.y);
        tr.transform((Point2D)this.geoCoords, (Point2D)this.geoCoords);
        this.geoCoords.setCoordinateReferenceSystem(pane.getMapContent().getCoordinateReferenceSystem());
    }

    public boolean isWheelEvent() {
        return this.isWheelEvent;
    }

    public int getWheelAmount() {
        return this.wheelAmount;
    }

    public Point getPoint() {
        return new Point(this.event.x, this.event.y);
    }

    public int getMouseButton() {
        return this.event.button;
    }

    public int getStateMask() {
        return this.event.stateMask;
    }

    public DirectPosition2D getMapPosition() {
        return new DirectPosition2D(this.geoCoords.getCoordinateReferenceSystem(), this.geoCoords.x, this.geoCoords.y);
    }
}

