/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class ProgressWindow
extends ProgressMonitorDialog
implements ProgressListener {
    private IProgressMonitor monitor;
    private String description;
    private final int taskSize;
    private float percent;
    private float previousPercent = -1.0f;

    public ProgressWindow(Shell parent, int taskSize) {
        super(parent);
        this.taskSize = taskSize;
        this.monitor = this.getProgressMonitor();
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.monitor.setCanceled(value);
    }

    public void setTask(InternationalString task) {
        this.setDescription(task.toString());
    }

    public InternationalString getTask() {
        return new SimpleInternationalString(this.getDescription());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void started() {
        this.monitor.beginTask(this.description, this.taskSize);
    }

    public void progress(float percent) {
        this.percent = percent;
        if (this.previousPercent == -1.0f) {
            this.monitor.worked((int)percent);
        } else {
            this.monitor.worked((int)(percent - this.previousPercent));
        }
        this.previousPercent = percent;
    }

    public float getProgress() {
        return this.percent;
    }

    public void complete() {
        this.monitor.done();
    }

    public void dispose() {
    }

    public void warningOccurred(String source, String location, String warning) {
    }

    public void exceptionOccurred(Throwable exception) {
    }
}

