/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.net.URL;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.geotools.data.Parameter;
import org.geotools.swt.control.JDoubleField;
import org.geotools.swt.control.JField;
import org.geotools.swt.control.JFileField;
import org.geotools.swt.control.JGeometryField;
import org.geotools.swt.control.JURLField;

public abstract class ParamField {
    protected Parameter<?> parameter;
    protected Composite parent;

    ParamField(Composite parent, Parameter<?> parameter) {
        this.parent = parent;
        this.parameter = parameter;
    }

    public abstract Control doLayout();

    public abstract boolean validate();

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public static ParamField create(Composite parent, Parameter<?> parameter) {
        if (Double.class.isAssignableFrom(parameter.type)) {
            return new JDoubleField(parent, parameter);
        }
        if (URL.class.isAssignableFrom(parameter.type)) {
            if (parameter.metadata != null && parameter.metadata.get("ext") != null) {
                return new JURLField(parent, parameter);
            }
            JField field = new JField(parent, parameter);
            field.setSingleLine(true);
            return field;
        }
        if (Boolean.class.isAssignableFrom(parameter.type)) {
            JField field = new JField(parent, parameter);
            field.setSingleLine(true);
            return field;
        }
        if (Number.class.isAssignableFrom(parameter.type)) {
            JField field = new JField(parent, parameter);
            field.setSingleLine(true);
            return field;
        }
        if (File.class.isAssignableFrom(parameter.type)) {
            return new JFileField(parent, parameter);
        }
        if (Geometry.class.isAssignableFrom(parameter.type)) {
            return new JGeometryField(parent, parameter);
        }
        return new JField(parent, parameter);
    }
}

