/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.geotools.data.FeatureSource;
import org.geotools.map.Layer;
import org.geotools.map.StyleLayer;
import org.geotools.styling.Style;
import org.geotools.swt.SwtMapPane;
import org.geotools.swt.styling.SimpleStyleConfigurator;
import org.geotools.swt.utils.ImageCache;
import org.geotools.swt.utils.Utils;

public class MaplayerTableViewer
extends TableViewer
implements ISelectionChangedListener {
    private List<Layer> layersList = new ArrayList<Layer>();
    private Layer selectedMapLayer;
    private String[] titles = new String[]{"Layer name", "Visible", "Style"};
    private SwtMapPane pane;

    public MaplayerTableViewer(Composite parent, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.addSelectionChangedListener(this);
        this.createColumns(parent, this);
        Table table = this.getTable();
        table.setHeaderVisible(true);
        this.setInput(this.layersList);
    }

    public void setPane(SwtMapPane pane) {
        this.pane = pane;
    }

    public List<Layer> getLayersList() {
        return this.layersList;
    }

    public Layer getSelectedMapLayer() {
        return this.selectedMapLayer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        int[] bounds = new int[]{120, 50, 50};
        TableViewerColumn col = this.createTableViewerColumn(this.titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Layer) {
                    Layer p = (Layer)element;
                    if (Utils.isGridLayer(p)) {
                        return ImageCache.getInstance().getImage("/icons/grid.gif");
                    }
                    return ImageCache.getInstance().getImage("/icons/feature.gif");
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof Layer) {
                    FeatureSource<?, ?> featureSource;
                    Layer p = (Layer)element;
                    String title = p.getTitle();
                    if ((title == null || title.length() == 0) && (featureSource = p.getFeatureSource()) != null) {
                        title = featureSource.getName().getLocalPart().toString();
                    }
                    return title;
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(this.titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Layer) {
                    Layer p = (Layer)element;
                    if (p.isVisible()) {
                        return ImageCache.getInstance().getImage("/icons/checked.gif");
                    }
                    return ImageCache.getInstance().getImage("/icons/unchecked.gif");
                }
                return null;
            }

            public String getText(Object element) {
                return null;
            }
        });
        col = this.createTableViewerColumn(this.titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return ImageCache.getInstance().getImage("/icons/style.gif");
            }

            public String getText(Object element) {
                return null;
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
        if (arg0 == null) {
            this.selectedMapLayer = null;
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)arg0.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof Layer) {
            this.selectedMapLayer = (Layer)firstElement;
        }
    }

    protected void triggerEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        super.triggerEditorActivationEvent(event);
        ViewerCell source = (ViewerCell)event.getSource();
        int columnIndex = source.getColumnIndex();
        if (columnIndex == 1) {
            Layer element;
            element.setVisible(!(element = (Layer)source.getElement()).isVisible());
            this.refresh();
            this.pane.redraw();
        } else if (columnIndex == 2) {
            Layer element = (Layer)source.getElement();
            try {
                this.doSetStyle(element);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pane.redraw();
        }
    }

    private void doSetStyle(Layer layer) throws IOException {
        if (layer instanceof StyleLayer) {
            StyleLayer styleLayer = (StyleLayer)layer;
            Style style = SimpleStyleConfigurator.showDialog(this.getTable().getShell(), layer);
            if (style != null) {
                styleLayer.setStyle(style);
            }
        }
    }

    public void addLayer(Layer layer) {
        this.layersList.add(0, layer);
        this.refresh();
    }

    public void removeLayer(Layer layer) {
        this.layersList.remove(layer);
        this.refresh();
    }

    public void clear() {
        this.layersList.clear();
        this.refresh();
    }
}

