/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.Parameter;
import org.geotools.swt.control.JFileDataStoreChooser;
import org.geotools.swt.control.ParamField;

public class JURLField
extends ParamField {
    private Text field;
    private Button browse;

    public JURLField(Composite parent, Parameter<?> parameter) {
        super(parent, parameter);
    }

    @Override
    public Control doLayout() {
        Composite composite = new Composite(this.parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.field = new Text(composite, 18436);
        this.field.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.browse = new Button(composite, 8);
        this.browse.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.browse.setText("...");
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JURLField.this.browse();
            }
        });
        return composite;
    }

    protected void browse() {
        FileDialog dialog;
        JFileDataStoreChooser tmpdialog;
        Object format = this.parameter.metadata.get("ext");
        if (format instanceof FileDataStoreFactorySpi) {
            tmpdialog = new JFileDataStoreChooser(this.parent.getShell(), 0, (FileDataStoreFactorySpi)format);
            dialog = tmpdialog.getFileDialog();
        } else if (format instanceof String) {
            tmpdialog = new JFileDataStoreChooser(this.parent.getShell(), 0, (String)format);
            dialog = tmpdialog.getFileDialog();
        } else if (format instanceof String[]) {
            tmpdialog = new JFileDataStoreChooser(this.parent.getShell(), 0, (String[])format);
            dialog = tmpdialog.getFileDialog();
        } else {
            dialog = new FileDialog(this.parent.getShell(), 0);
        }
        dialog.setFileName(this.getFile().getAbsolutePath());
        String returnVal = dialog.open();
        if (returnVal != null && returnVal.length() >= 1) {
            this.setValue(new File(returnVal));
        }
    }

    @Override
    public URL getValue() {
        String txt = this.field.getText();
        if (txt == null || txt.equals("")) {
            return null;
        }
        try {
            File file = new File(txt);
            return file.toURI().toURL();
        }
        catch (Exception e) {
            try {
                return new URL(txt);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    public File getFile() {
        String txt = this.field.getText();
        if (txt == null || txt.equals("")) {
            return null;
        }
        try {
            File file = new File(txt);
            return file;
        }
        catch (Exception e) {
            try {
                URL url = new URL(txt);
                return DataUtilities.urlToFile(url);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof File) {
            File file = (File)value;
            this.field.setText(file.toString());
        } else if (value instanceof URL) {
            URL url = (URL)value;
            this.field.setText(url.toExternalForm());
        } else if (value instanceof String) {
            this.field.setText((String)value);
        }
    }

    @Override
    public boolean validate() {
        String txt = this.field.getText();
        if (txt == null || txt.equals("")) {
            return !this.parameter.required;
        }
        File file = this.getFile();
        if (file != null) {
            return file.exists();
        }
        URL url = this.getValue();
        return url != null;
    }
}

