/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.geotools.swt.utils.Utils;

public class JTextReporter
extends Dialog {
    private Text textArea;
    private final String title;

    public JTextReporter(Shell parent, String title) {
        super(parent);
        this.title = title;
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.title);
        newShell.setSize(250, 400);
        super.configureShell(newShell);
    }

    public synchronized void append(final String text) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                sb.append(JTextReporter.this.textArea.getText());
                sb.append("\n");
                sb.append(text);
                JTextReporter.this.textArea.setText(sb.toString());
                JTextReporter.this.textArea.setSelection(JTextReporter.this.textArea.getCharCount());
            }
        };
        Utils.runGuiRunnableSafe(runner, true);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.textArea = new Text(parent, 2626);
        this.textArea.setEditable(false);
        GridData textAreaGD = new GridData(4, 4, true, true);
        this.textArea.setLayoutData((Object)textAreaGD);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 1024, true, false));
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        Button saveButton = new Button(buttonComposite, 8);
        saveButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        saveButton.setText("Save");
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JTextReporter.this.saveReport();
            }
        });
        Button clearButton = new Button(buttonComposite, 8);
        clearButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        clearButton.setText("Clear");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JTextReporter.this.clearReport();
            }
        });
        return parent;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return null;
    }

    private void clearReport() {
        this.textArea.setText("");
    }

    private void saveReport() {
        Writer writer = null;
        try {
            File file = this.getFile();
            if (file != null) {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(this.textArea.getText());
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private File getFile() {
        FileDialog fileDialog = new FileDialog(this.textArea.getShell(), 8192);
        String path = fileDialog.open();
        if (path == null || path.length() < 1) {
            return null;
        }
        return new File(path);
    }
}

