/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.geotools.data.DataUtilities;
import org.geotools.data.Parameter;
import org.geotools.swt.control.JParameterListPage;

public class JParameterListWizard
extends Wizard {
    private Map<String, Object> connectionParameters;
    private JParameterListPage userPage;
    private JParameterListPage advancedPage;

    public JParameterListWizard(String title, String description, List<Parameter<?>> contents) {
        this(title, description, contents, new HashMap<String, Object>());
    }

    public JParameterListWizard(String title, String description, List<Parameter<?>> contents, Map<String, Object> connectionParams) {
        this.connectionParameters = connectionParams == null ? new HashMap() : connectionParams;
        this.fillInDefaults(contents, this.connectionParameters);
        List<Parameter<?>> userContents = this.contentsForLevel(contents, "user");
        this.userPage = new JParameterListPage(title, description, userContents, this.connectionParameters);
        List<Parameter<?>> advancedContents = this.contentsForLevel(contents, "advanced");
        if (advancedContents.size() > 0) {
            this.advancedPage = new JParameterListPage(title, description, advancedContents, this.connectionParameters);
        }
    }

    public void addPages() {
        super.addPages();
        if (this.userPage != null) {
            this.addPage((IWizardPage)this.userPage);
        }
        if (this.advancedPage != null) {
            this.addPage((IWizardPage)this.advancedPage);
        }
    }

    public boolean performFinish() {
        return false;
    }

    private void fillInDefaults(List<Parameter<?>> contents, Map<String, Object> connectionParams) {
        if (connectionParams == null) {
            return;
        }
        for (Parameter<?> param : contents) {
            if (!param.required || !"program".equals(param.getLevel()) || connectionParams.containsKey(param.key)) continue;
            connectionParams.put(param.key, param.sample);
        }
    }

    List<Parameter<?>> contentsForLevel(List<Parameter<?>> contents, String level) {
        ArrayList list = new ArrayList();
        if (level == null) {
            level = "user";
        }
        if (contents != null) {
            for (Parameter<?> param : contents) {
                String check;
                if (level == null) continue;
                String string = check = param.metadata == null ? "user" : (String)param.metadata.get("level");
                if (check == null) {
                    check = "user";
                }
                if (!level.equals(check)) continue;
                list.add(param);
            }
        }
        return list;
    }

    public Map<String, Object> getConnectionParameters() {
        return this.connectionParameters;
    }

    public File getFile() {
        URL url = (URL)this.connectionParameters.get("url");
        return DataUtilities.urlToFile(url);
    }
}

