/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.data.Parameter;
import org.geotools.swt.control.ParamField;
import org.geotools.util.Converters;

public class JParameterListPage
extends WizardPage {
    public static final String ID = "org.geotools.swt.data.ParameterListPage";
    List<Parameter<?>> contents;
    private Map<Parameter<?>, ParamField> fields = new HashMap();
    protected Map<String, Object> connectionParameters;

    public JParameterListPage(String title, String description, List<Parameter<?>> contents, Map<String, Object> params) {
        super(ID);
        this.contents = contents;
        this.connectionParameters = params;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        mainComposite.setLayout((Layout)gridLayout);
        for (Parameter<?> param : this.contents) {
            String txt = param.title.toString();
            if (param.required) {
                txt = txt + "*";
            }
            Label label = new Label(mainComposite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(txt);
            ParamField field = ParamField.create(mainComposite, param);
            field.doLayout();
            this.fields.put(param, field);
        }
        this.setControl((Control)mainComposite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.preDisplayPanel();
        } else {
            this.preClosePanel();
        }
        super.setVisible(visible);
    }

    private void preDisplayPanel() {
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            Parameter<?> param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = null;
            Object object = this.connectionParameters.get(param.key);
            value = Converters.convert((Object)object, (Class)param.type);
            if (value == null) {
                value = object;
            }
            if (value == null && param.required) {
                value = param.sample;
            }
            field.setValue(value);
        }
    }

    private void preClosePanel() {
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            Parameter<?> param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = field.getValue();
            this.connectionParameters.put(param.key, value);
        }
    }

    public boolean isValid() {
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            Parameter<?> param = entry.getKey();
            ParamField field = entry.getValue();
            if (!field.validate()) {
                return false;
            }
            if (!param.required || field.getValue() != null) continue;
            return false;
        }
        return true;
    }
}

