/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.geotools.swt.control.JValueField;
import org.geotools.swt.control.ValueChangedEvent;

public class JIntegerField
extends JValueField
implements ModifyListener {
    private boolean fireEvents;
    private final boolean allowNegative;

    public JIntegerField(Composite parent, int style) {
        this(parent, style, 0, true);
    }

    public JIntegerField(Composite parent, int style, boolean allowsNegative) {
        this(parent, style, 0, allowsNegative);
    }

    public JIntegerField(Composite parent, int style, int value) {
        this(parent, style, value, true);
    }

    public JIntegerField(Composite parent, int style, int value, boolean allowNegative) {
        super(parent, style);
        this.addModifyListener(this);
        this.allowNegative = allowNegative;
        this.setValue(value);
    }

    public int getValue() {
        return Integer.parseInt(this.getText());
    }

    public void setValue(int value) {
        this.setValue(value, true);
    }

    public void setValue(int value, boolean publishEvent) {
        this.fireEvents = publishEvent;
        if (!this.allowNegative && value < 0) {
            throw new IllegalArgumentException(String.format("Negative value (%d) but text field set to only allow positive values", value));
        }
        this.setText(String.valueOf(value));
        this.fireEvents = true;
    }

    public void modifyText(ModifyEvent arg0) {
        if (this.fireEvents) {
            ValueChangedEvent<Integer> ev = new ValueChangedEvent<Integer>((Control)this, Integer.valueOf(this.getText()));
            this.fireValueChangedEvent(ev);
        }
    }
}

