/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.Parameter;
import org.geotools.swt.control.ParamField;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGeometryField
extends ParamField {
    private Text text;

    public JGeometryField(Composite parent, Parameter<?> parameter) {
        super(parent, parameter);
    }

    @Override
    public Control doLayout() {
        this.text = new Text(this.parent, 2626);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JGeometryField.this.validate();
            }
        });
        return this.text;
    }

    @Override
    public Object getValue() {
        WKTReader reader = new WKTReader();
        String wkt = this.text.getText();
        if (wkt.length() == 0) {
            return null;
        }
        try {
            return reader.read(wkt);
        }
        catch (Throwable eek) {
            return null;
        }
    }

    int getD() {
        try {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.parameter.metadata.get("crs");
            if (crs == null) {
                return 2;
            }
            return crs.getCoordinateSystem().getDimension();
        }
        catch (Throwable t) {
            return 2;
        }
    }

    @Override
    public void setValue(Object value) {
        Geometry geom = (Geometry)value;
        WKTWriter writer = new WKTWriter(this.getD());
        String wkt = writer.write(geom);
        this.text.setText(wkt);
    }

    @Override
    public boolean validate() {
        WKTReader reader = new WKTReader();
        String wkt = this.text.getText();
        if (wkt.length() == 0) {
            return true;
        }
        try {
            Geometry geom = reader.read(wkt);
            if (this.parameter.type.isInstance(geom)) {
                this.text.setToolTipText(null);
                this.text.setForeground(Display.getCurrent().getSystemColor(2));
                return true;
            }
            this.text.setToolTipText("Could not use " + geom.getClass() + " as " + this.parameter.type);
            this.text.setForeground(Display.getCurrent().getSystemColor(3));
            return false;
        }
        catch (Throwable eek) {
            this.text.setToolTipText(eek.getLocalizedMessage());
            this.text.setForeground(Display.getCurrent().getSystemColor(3));
            return false;
        }
    }
}

