/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class JFileImageChooser {
    private static final Set<FormatSpecifier> supportedReaders = new TreeSet<FormatSpecifier>();
    private static final Set<FormatSpecifier> supportedWriters = new TreeSet<FormatSpecifier>();
    private FileDialog fileDialog;
    private List<String> extentionsList = new ArrayList<String>();

    public JFileImageChooser(Shell parent, int style) {
        this(parent, style, null);
    }

    public JFileImageChooser(Shell parent, int style, File workingDir) {
        this.fileDialog = new FileDialog(parent, style);
        if (workingDir != null) {
            this.fileDialog.setFilterPath(workingDir.getAbsolutePath());
        }
    }

    private void setFilter(Set<FormatSpecifier> supportedFormats) {
        for (FormatSpecifier format : supportedFormats) {
            String[] suffixes = format.suffixes;
            for (int i = 0; i < suffixes.length; ++i) {
                if (!suffixes[i].startsWith("*.")) {
                    suffixes[i] = suffixes[i].startsWith(".") ? "*" + suffixes[i] : "*." + suffixes[i];
                }
                this.extentionsList.add(suffixes[i]);
            }
        }
        String[] extArray = this.extentionsList.toArray(new String[this.extentionsList.size()]);
        this.fileDialog.setFilterExtensions(extArray);
    }

    public FileDialog getFileDialog() {
        return this.fileDialog;
    }

    public static File showSaveFile(Shell parent) {
        return JFileImageChooser.showSaveFile(parent, null);
    }

    public static File showSaveFile(Shell parent, File workingDir) {
        JFileImageChooser chooser = new JFileImageChooser(parent, 8192, workingDir);
        chooser.setFilter(supportedWriters);
        FileDialog dialog = chooser.getFileDialog();
        dialog.setText("Save image");
        String path = dialog.open();
        File file = null;
        if (path != null && path.length() >= 1) {
            file = new File(path);
        }
        return file;
    }

    public static File showOpenFile(Shell parent) {
        return JFileImageChooser.showOpenFile(parent, null);
    }

    public static File showOpenFile(Shell parent, File workingDir) {
        JFileImageChooser chooser = new JFileImageChooser(parent, 4096, workingDir);
        chooser.setFilter(supportedReaders);
        FileDialog dialog = chooser.getFileDialog();
        dialog.setText("Open image file");
        String path = dialog.open();
        File file = null;
        if (path != null && path.length() >= 1) {
            file = new File(path);
        }
        return file;
    }

    static {
        for (FormatSpecifier format : FormatSpecifier.values()) {
            if (ImageIO.getImageReadersBySuffix(format.id).hasNext()) {
                supportedReaders.add(format);
            }
            if (!ImageIO.getImageWritersBySuffix(format.id).hasNext()) continue;
            supportedWriters.add(format);
        }
    }

    private static enum FormatSpecifier {
        TIF("tif", "TIFF image", "*.tif", "*.tiff"),
        BMP("bmp", "BMP image", "*.bmp"),
        GIF("gif", "GIF image", "*.gif"),
        JPG("jpg", "JPEG image", "*.jpg", "*.jpeg"),
        PNG("png", "PNG image", "*.png");

        private String id;
        private String[] suffixes;

        private FormatSpecifier(String id, String desc, String ... suffixes) {
            this.id = id;
            this.suffixes = new String[suffixes.length];
            for (int i = 0; i < suffixes.length; ++i) {
                this.suffixes[i] = suffixes[i];
            }
        }
    }
}

