/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;

public class JFileDataStoreChooser {
    private static final long serialVersionUID = -7482109609487216939L;
    private FileDialog fileDialog;

    public JFileDataStoreChooser(Shell parent, int style, String extension) {
        this(parent, style, new String[]{extension});
    }

    static Map<String, String> associations(List<String> extensions) {
        TreeMap<String, String> fileAssociations = new TreeMap<String, String>();
        for (String extension : extensions) {
            FileDataStoreFactorySpi factory;
            String ext = extension.toLowerCase().trim();
            if (!ext.startsWith("*.")) {
                ext = ext.startsWith(".") ? "*" + ext : "*." + ext;
            }
            if ((factory = FileDataStoreFinder.getDataStoreFactory(ext)) != null) {
                fileAssociations.put(ext, factory.getDescription());
                continue;
            }
            if (".csv".equals(ext)) {
                fileAssociations.put(ext, "Comma-delimited files (*.csv)");
                continue;
            }
            if (ext.startsWith(".tif")) {
                fileAssociations.put(ext, "GeoTIFF files (*.tif; *.tiff)");
                continue;
            }
            fileAssociations.put(ext, ext.toUpperCase().substring(1) + "files (*" + ext + ")");
        }
        return fileAssociations;
    }

    public JFileDataStoreChooser(Shell parent, int style, List<String> extensions) {
        this(parent, style, JFileDataStoreChooser.associations(extensions));
    }

    public JFileDataStoreChooser(Shell parent, int style, String[] extensions) {
        this(parent, style, JFileDataStoreChooser.associations(Arrays.asList(extensions)));
    }

    public JFileDataStoreChooser(Shell parent, int style, Map<String, String> fileAssociations) {
        this.fileDialog = new FileDialog(parent, style);
        this.init(fileAssociations);
    }

    private void init(Map<String, String> fileAssociations) {
        String[] exts = new String[fileAssociations.size()];
        String[] descr = new String[fileAssociations.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : fileAssociations.entrySet()) {
            exts[i] = entry.getKey();
            descr[i] = entry.getValue();
            ++i;
        }
        this.fileDialog.setFilterExtensions(exts);
        this.fileDialog.setFilterNames(descr);
    }

    public JFileDataStoreChooser(Shell parent, int style, FileDataStoreFactorySpi format) {
        this.fileDialog = new FileDialog(parent, style);
        this.fileDialog.setFilterExtensions(format.getFileExtensions());
    }

    public FileDialog getFileDialog() {
        return this.fileDialog;
    }

    public static File showOpenFile(String extension, Shell parent) {
        return JFileDataStoreChooser.showOpenFile(extension, null, parent);
    }

    public static File showOpenFile(String extension, File initialDir, Shell parent) {
        JFileDataStoreChooser dialog = new JFileDataStoreChooser(parent, 4096, extension);
        FileDialog fileDialogInternal = dialog.getFileDialog();
        if (initialDir != null) {
            if (initialDir.isDirectory()) {
                fileDialogInternal.setFilterPath(initialDir.getAbsolutePath());
            } else {
                fileDialogInternal.setFilterPath(initialDir.getParentFile().getAbsolutePath());
            }
        }
        fileDialogInternal.open();
        String filePath = fileDialogInternal.getFileName();
        File file = new File(filePath);
        return file;
    }

    public static File showOpenFile(String[] extensions, Shell parent) {
        return JFileDataStoreChooser.showOpenFile(extensions, null, parent);
    }

    public static File showOpenFile(String[] extensions, File initialDir, Shell parent) {
        String filePath;
        JFileDataStoreChooser dialog = new JFileDataStoreChooser(parent, 4096, extensions);
        FileDialog fileDialogInternal = dialog.getFileDialog();
        if (initialDir != null) {
            if (initialDir.isDirectory()) {
                fileDialogInternal.setFilterPath(initialDir.getAbsolutePath());
            } else {
                fileDialogInternal.setFilterPath(initialDir.getParentFile().getAbsolutePath());
            }
        }
        if ((filePath = fileDialogInternal.open()) != null) {
            File file = new File(filePath);
            return file;
        }
        return null;
    }

    public static File showOpenFile(FileDataStoreFactorySpi format, Shell parent) {
        return JFileDataStoreChooser.showOpenFile(format, null, parent);
    }

    public static File showOpenFile(FileDataStoreFactorySpi format, File initialDir, Shell parent) {
        JFileDataStoreChooser dialog = new JFileDataStoreChooser(parent, 4096, format);
        FileDialog fileDialogInternal = dialog.getFileDialog();
        if (initialDir != null) {
            if (initialDir.isDirectory()) {
                fileDialogInternal.setFilterPath(initialDir.getAbsolutePath());
            } else {
                fileDialogInternal.setFilterPath(initialDir.getParentFile().getAbsolutePath());
            }
        }
        fileDialogInternal.open();
        String filePath = fileDialogInternal.getFileName();
        File file = new File(filePath);
        return file;
    }

    public static void main(String[] arg) {
        Display display = new Display();
        Shell shell = new Shell(display);
        File file = JFileDataStoreChooser.showOpenFile("shp", shell);
        if (file != null) {
            MessageDialog.openInformation((Shell)shell, (String)"INFO", (String)("Selected " + file.getAbsolutePath()));
        } else {
            MessageDialog.openInformation((Shell)shell, (String)"INFO", (String)"Selection cancelled");
        }
    }

    public void setSaveFile(File file) {
        String extension;
        String base;
        String path = file.getAbsolutePath();
        int split = path.lastIndexOf(46);
        if (split == -1) {
            base = path;
            extension = "";
        } else {
            base = path.substring(0, split);
            extension = path.substring(split);
        }
        File saveFile = new File(path);
        int number = 0;
        while (saveFile.exists()) {
            saveFile = new File(base + number++ + extension);
        }
        this.fileDialog.setFileName(saveFile.getAbsolutePath());
    }
}

