/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.Parameter;
import org.geotools.swt.control.ParamField;
import org.geotools.util.Converters;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JField
extends ParamField {
    private Text text;
    private boolean single = true;

    public JField(Composite parent, Parameter<?> parameter) {
        super(parent, parameter);
    }

    public void setSingleLine(boolean single) {
        this.single = single;
    }

    @Override
    public Control doLayout() {
        if (this.parameter.metadata != null && this.parameter.metadata.get("isPassword") == Boolean.TRUE) {
            this.text = new Text(this.parent, 0x404804);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else if (this.single) {
            this.text = new Text(this.parent, 18436);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else {
            this.text = new Text(this.parent, 2626);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                JField.this.validate();
            }
        });
        return this.text;
    }

    @Override
    public Object getValue() {
        String txt = this.text.getText();
        if (txt.length() == 0) {
            return null;
        }
        Object value = Converters.convert((Object)txt, (Class)this.parameter.type);
        return value;
    }

    int getD() {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.parameter.metadata.get("crs");
        if (crs == null) {
            return 2;
        }
        return crs.getCoordinateSystem().getDimension();
    }

    @Override
    public void setValue(Object value) {
        String txt = (String)Converters.convert((Object)value, String.class);
        if (txt == null) {
            txt = "";
        }
        this.text.setText(txt);
    }

    @Override
    public boolean validate() {
        String txt = this.text.getText();
        if (txt.length() == 0) {
            return true;
        }
        Object value = Converters.convert((Object)txt, (Class)this.parameter.type);
        if (value == null) {
            this.text.setToolTipText("Could not create " + this.parameter.type);
            this.text.setForeground(Display.getCurrent().getSystemColor(3));
            return false;
        }
        this.text.setToolTipText(null);
        this.text.setForeground(Display.getCurrent().getSystemColor(2));
        return true;
    }
}

