/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swt.control;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.Parameter;
import org.geotools.swt.control.ParamField;

public class JDoubleField
extends ParamField {
    private Text text;

    public JDoubleField(Composite parent, Parameter<?> parameter) {
        super(parent, parameter);
    }

    @Override
    public Control doLayout() {
        this.text = new Text(this.parent, 18436);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return this.text;
    }

    @Override
    public Object getValue() {
        String val = this.text.getText();
        if (val == null || val.equals("")) {
            return new Double(0.0);
        }
        try {
            return new Double(val);
        }
        catch (NumberFormatException e) {
            return new Double(0.0);
        }
    }

    @Override
    public void setValue(Object value) {
        this.text.setText(((Double)value).toString());
    }

    @Override
    public boolean validate() {
        String val = this.text.getText();
        try {
            Double d = Double.parseDouble(val);
            return d != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

